/*
 * msg.cc - MessageWindow class
 */

#include "gui.h"

MessageWindow::MessageWindow(char *section, int flags, int w, int h, char *filename)
 : Window(section, flags, w, h)
{
   char str[200];
   file = fopen(filename, "w");
   head = tail = 0;

   sprintf(str, "%s log", section);
   SetTitle(str);

   Print("%s log started.", section);
}

MessageWindow::~MessageWindow()
{
   Print("%s log ended.", section);
   fclose(file);
}

void MessageWindow::Draw(BITMAP *bmp)
{
   int start, end, y, h;

   clear_to_color(bmp, GUI::c_background);
   if (head == tail) return;

   text_mode(-1);
   start = head;
   end = tail;
   h = text_height(font);
   
   y = bmp->h - h;
   while (end != start)
   {
      end--;
      if (end < 0) end = LOG_MAX-1;
      if (urgent[end])
      {
         textout(bmp, font, msgs[end],
                 1, y, GUI::c_urgent);
         hline(bmp, 1, y + h - gui_font_baseline,
               text_length(font, msgs[end]), GUI::c_urgent);
      } else {
         textout(bmp, font, msgs[end],
                 1, y, GUI::c_text);
      }
      y -= h;
      if (y <= -h) break;
   }
}

void MessageWindow::Print(char *msg, ...)
{
   char text[300];
   va_list ap;
  
   va_start(ap, msg);
   vsprintf(text, msg, ap);
   va_end(ap);

   strcpy(msgs[tail], text);
   urgent[tail] = false;

   tail++;
   if (tail >= LOG_MAX) tail = 0;
   if (tail == head)
   {
      head++;
      if (head >= LOG_MAX) head = 0;
   }

   if (file) fprintf(file, "%s\n", text);
   fflush(file);
   RequestRedraw();
   if (this == log)
   {
      GUI::infoline = true;
      strcpy(GUI::infoline_msg, text);
      GUI::infoline_colour = INFOLINE_SPEED;
      GUI::infoline_error = false;
      text_mode(-1);
      int h = text_height(font);
      rectfill(screen, 0,SCREEN_H-INFOLINE_HEIGHT, SCREEN_W-1, SCREEN_H-1,
         makecol(0,0,0));
      textout(screen, font, text,
         4, SCREEN_H-((INFOLINE_HEIGHT+h) / 2),
         makecol(255,255,255));
   }
}

void MessageWindow::Error(char *msg, ...)
{
   char text[300];
   va_list ap;
  
   va_start(ap, msg);
   vsprintf(text, msg, ap);
   va_end(ap);

   strcpy(msgs[tail], text);
   urgent[tail] = true;

   tail++;
   if (tail >= LOG_MAX) tail = 0;
   if (tail == head)
   {
      head++;
      if (head >= LOG_MAX) head = 0;
   }

   if (file) fprintf(file, "%s\n", text);
   fflush(file);
   RequestRedraw();
   if (this == log)
   {
      Select();
      GUI::infoline = true;
      strcpy(GUI::infoline_msg, text);
      GUI::infoline_colour = INFOLINE_SPEED;
      GUI::infoline_error = true;
      text_mode(-1);
      int h = text_height(font);
      rectfill(screen, 0,SCREEN_H-INFOLINE_HEIGHT, SCREEN_W-1, SCREEN_H-1,
         makecol(0,0,0));
      textout(screen, font, text,
         4, SCREEN_H-((INFOLINE_HEIGHT+h) / 2),
         makecol(255,255,255));
   }
}
