/*
 * test.cc - GUI test code
 */

#include "gui.h"

int main()
{
   allegro_init();
   set_config_file("test.ini");

   try {
      gui = new GUI();
   } catch (OutOfMemoryException &e) {
      fprintf(stderr, "Out of memory!\n");
      return 1;
   } catch (Exception &e) {
      return 1;
   }

   log->Print("*** GUI Test Program ***");

   BITMAP *desktop = create_bitmap(SCREEN_W, SCREEN_H);
   clear_to_color(desktop, makecol(0xa0, 0xdb, 0xff));
   gui->SetDesktop(desktop);
   destroy_bitmap(desktop);

   BitmapWindow *test1 = new BitmapWindow("Test1", W_CLOSE, 150, 100);
   test1->vsync = HIGH;
   test1->SetTitle("Test bitmap 1");

   BitmapWindow *test2 = new BitmapWindow("Test2", W_CLOSE, 150, 100);
   test2->vsync = HIGH;
   test2->SetTitle("Test bitmap 2");

   gui->Run();

   delete test1;
   delete test2;

   delete gui;
   return 0;
}
