/* small util to view palette
 * needs RAM dump from Virtua to exist
 */

#include <stdio.h>
#include <conio.h>
#include <allegro.h>

unsigned char ROM[0x4000];

int main()
{
   unsigned char c1, c2;
   unsigned short c;
   int n, bit0,bit1,bit2,bit3, val, r,g,b, x,y, pos;
   FILE *file;
   RGB rgb;
   PALETTE pal;

   file = fopen("ram180.bin", "rb");
   fread(&ROM[0], 1, 0x4000, file);
   fclose(file);

   allegro_init();
   set_color_depth(16);
   set_gfx_mode(GFX_AUTODETECT, 320,200,0,0);
   install_keyboard();

   pos = 0;
   while(!key[KEY_ESC])
   {
      vsync();
      for (y=0;y<16;y++)
      {
         for (x=0;x<16;x++)
         {
            c1 = ROM[(pos + y*16 + x)*2];
            c2 = ROM[(pos + y*16 + x)*2 + 1];
            c = (c2<<8) + c1;

            r = c & 31;
            g = (c >> 5) & 31;
            b = (c >> 10) & 31;

            r *= 8; g *= 8; b *= 8;

            rectfill(screen, x*8,y*8, x*8+7, y*8+7, makecol(r,g,b));
         }
         textprintf(screen, font, 132, y*8, makecol(255,255,255), "0x%.3x", pos/16+y);
      }
      if (key[KEY_DOWN]) pos += 16;
      if (key[KEY_UP]) pos -= 16;
      if (pos < 0) pos = 0;
      if (pos > (512-16)*16) pos = (512-16)*16;
   }
   return 0;
}
