/* Intel i960 CPU emulator
 *
 * Command-line CPU disassembler (80960KB only).
 *
 * Copyright (c) 1999 Richard Mitton
 */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#include "i960dasm.h"

static iWORD *ROM;

void i960_Message(int fatal, char *msg)
{
   printf("%s\n", msg);
   if (fatal) exit(1);
}

iWORD i960_ReadMem32(iWORD addr)
{
   return ROM[addr >> 2];
}

int main(int argc, char *argv[])
{
   FILE *file;
   char buf[200];
   int n, end, num_ops;
   iWORD pc;

   if (argc != 3)
   {
      fprintf(stderr, "i960 disassembler.\n"
                      "Usage: d960 in.rom out.txt\n");
      return 1;
   }

   printf("d960: disassembling '%s'...", argv[1]);

   file = fopen(argv[1], "rb");
   if (!file)
   {
      perror(argv[1]);
      return 1;
   }

   fseek(file, 0, SEEK_END);
   num_ops = ftell(file);
   fseek(file, 0, SEEK_SET);

   ROM = (iWORD *)malloc(sizeof(iWORD) * num_ops);
   if (!ROM)
   {
      fprintf(stderr, "Out of memory for ROM file.\n");
      fclose(file);
      return 2;
   }

   fread(ROM, sizeof(iWORD), num_ops, file);
   fclose(file);

   file = fopen(argv[2], "w");
   if (!file)
   {
      perror(argv[2]);
      return 1;
   }

   fprintf(file, "; Disassembly of the file '%s'\n"
                 ";\n"
                 "; Created by d960. d960 is copyright (c) 1999 Richard Mitton\n"
                 "; Initial IP=0x%x\n"
                 ";\n", argv[1], ROM[3]);
   pc = 0;
   do {
      if (pc == ROM[3]) fprintf(file, "\n; Initial IP starts here\n");

      n = i960_Dasm(&buf[0], pc, &end);
      fprintf(file, "0x%.8x:       %s\n", pc, buf);
      if (end) fprintf(file, "\n");
      pc += n*4;
   } while(pc < num_ops);

   fclose(file);
   printf("done\n");
   return 0;
}
