#include "virtua.h"
#include "i960dasm.h"

Debugger::Debugger(Model2 *emu)
 : Window("Debugger", W_CLOSE, 260, 204)
{
   log->Print("Debugger: started.");
   SetTitle("Debugger");
   this->emu = emu;
   emu->paused = true;
   breakpoint = get_config_hex("Debugger", "breakpoint", 0);
}

Debugger::~Debugger()
{
   log->Print("Debugger: ended.");
   emu->debugger = NULL;
}

void Debugger::Draw(BITMAP *bmp)
{
   iWORD ip, new_ip;
   int c, y, end;
   char text[200];

   clear_to_color(bmp, GUI::c_background);
   text_mode(-1);

   ip = i960_GetIP();
   y = 0;
   do {
      new_ip = ip + i960_Dasm(&text[0], ip, &end)*sizeof(iWORD);
      if (ip == i960_GetIP())
         c = GUI::c_urgent;
      else
         c = GUI::c_text;
      textprintf(bmp, font, 1, y, c, "0x%.8x: %s", ip, text);
      y += text_height(font);
      if (end) y += text_height(font);
      ip = new_ip;
   } while(y <= bmp->h);
}

void Debugger::Reset(void)
{
#ifdef __I960_DEBUGGER__
   i960_SetBreakPoint(breakpoint);
#endif
}

bool Debugger::KeyPress(int scancode)
{
   if (!emu->paused) return false;

   switch(scancode) {
   case KEY_F8:
      emu->SingleStep();
      break;
   default: return false;
   }
   return true;
}

void Debugger::CheckBreakPoint(void)
{
   if (i960_GetIP() == breakpoint)
   {
      emu->paused = true;
      log->Error("Debugger: breakpoint hit.");
      io->Error("Breakpoint hit.");
   }
}

void Debugger::SetBreakPoint(iWORD bp)
{
#ifdef __I960_DEBUGGER__
   breakpoint = bp;
   i960_SetBreakPoint(bp);
#endif
}


