; Don't trust *anything* in this file.
; Check against the C versions first!
; Note: This is totally useless and also wrong at this time.

; Intel i960 CPU emulator
;
; Assembler instructions
;
; Copyright (c) 1999 Richard Mitton

; Register conventions -
;         IP = ESI
;       Src1 = ECX
;       Src2 = EAX
;     SrcDst = EBX
;     MEM/EA = ECX
;    CTRL/EA = EAX
;    COBR/EA = EBX

%include "i960asm.inc"

%macro INSTRUCTION 1
   align 16
   global _i_%{1}_start
_i_%{1}_start:
%endmacro

%macro END_INSTRUCTION 1
   global _i_%{1}_end
_i_%{1}_end:
%endmacro

section .text

CheckIAC:
   ret

;-------------------------------------------------------------------------------
; Opcode 80 - ldob (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldob
   mov edi, ecx
	call [ebp+OFF_READMEM8]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldob

;-------------------------------------------------------------------------------
; Opcode 82 - stob (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stob
   mov edi, [ebp+OFF_REGS+ebx*4]
	mov edx, edi
   mov edi, ecx
	call [ebp+OFF_WRITEMEM8]   ; edi -> [addr]
END_INSTRUCTION stob

;-------------------------------------------------------------------------------
; Opcode 84 - bx (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION bx
   mov esi, ecx
END_INSTRUCTION bx

;-------------------------------------------------------------------------------
; Opcode 85 - balx (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION balx
   ; FIXME! this is wrong
	mov [ebp+OFF_REGS+30*4], esi
   lea esi, [esi+eax-4]
END_INSTRUCTION balx

;-------------------------------------------------------------------------------
; Opcode 86 - callx (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION callx
   ; FIXME - write this
END_INSTRUCTION callx
                     
;-------------------------------------------------------------------------------
; Opcode 88 - ldos (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldos
   mov edi, ecx
   call [ebp+OFF_READMEM16]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldos

;-------------------------------------------------------------------------------
; Opcode 8a - stos (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stos
   mov edi, [ebp+OFF_REGS+ebx*4]
	mov edx, edi
   mov edi, ecx
	call [ebp+OFF_WRITEMEM16]   ; edi -> [addr]
END_INSTRUCTION stos

;-------------------------------------------------------------------------------
; Opcode 8c - lda (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION lda
   mov [ebp+OFF_REGS+ebx*4], ecx
END_INSTRUCTION lda

;-------------------------------------------------------------------------------
; Opcode 90 - ld (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ld
   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ld

;-------------------------------------------------------------------------------
; Opcode 92 - st (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION st
   mov edi, [ebp+OFF_REGS+ebx*4]
	mov edx, edi
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edi -> [addr]
END_INSTRUCTION st

;-------------------------------------------------------------------------------
; Opcode 98 - ldl (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldl
   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldl

;-------------------------------------------------------------------------------
; Opcode 9a - stl (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stl
   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
END_INSTRUCTION stl

;-------------------------------------------------------------------------------
; Opcode a0 - ldt (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldt
   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldt

;-------------------------------------------------------------------------------
; Opcode a2 - stt (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stt
   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
END_INSTRUCTION stt

;-------------------------------------------------------------------------------
; Opcode b0 - ldq (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldq
   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
   add ecx, 4
   inc ebx

   mov edi, ecx
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldq

;-------------------------------------------------------------------------------
; Opcode b2 - stq (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stq
   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
   add ecx, 4
   inc ebx

   mov edx, [ebp+OFF_REGS+ebx*4]
   mov edi, ecx
   call [ebp+OFF_WRITEMEM]   ; reg -> [addr]
END_INSTRUCTION stq

;-------------------------------------------------------------------------------
; Opcode c0 - ldib (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldib
   mov edi, ecx
	call [ebp+OFF_READMEM8]   ; [addr] -> edx
   movsx edx, dl
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldib

;-------------------------------------------------------------------------------
; Opcode c2 - stib (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stib
   mov edi, [ebp+OFF_REGS+ebx*4]
	mov edx, edi
   mov edi, ecx
	call [ebp+OFF_WRITEMEM8]   ; edi -> [addr]
END_INSTRUCTION stib

;-------------------------------------------------------------------------------
; Opcode c8 - ldis (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION ldis
   mov edi, ecx
   call [ebp+OFF_READMEM16]   ; [addr] -> edx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION ldis

;-------------------------------------------------------------------------------
; Opcode ca - stis (MEM)
;-------------------------------------------------------------------------------
INSTRUCTION stis
   mov edi, [ebp+OFF_REGS+ebx*4]
	mov edx, edi
   mov edi, ecx
	call [ebp+OFF_WRITEMEM16]   ; edi -> [addr]
END_INSTRUCTION stis

;-------------------------------------------------------------------------------
; Opcode 580 - notbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION notbit
   btc eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION notbit

;-------------------------------------------------------------------------------
; Opcode 581 - and (REG)
;-------------------------------------------------------------------------------
INSTRUCTION and
   and eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION and

;-------------------------------------------------------------------------------
; Opcode 586 - xor (REG)
;-------------------------------------------------------------------------------
INSTRUCTION xor
   xor eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION xor

;-------------------------------------------------------------------------------
; Opcode 587 - or (REG)
;-------------------------------------------------------------------------------
INSTRUCTION or
   or eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION or

;-------------------------------------------------------------------------------
; Opcode 582 - andnot (REG)
;-------------------------------------------------------------------------------
INSTRUCTION andnot
   not ecx
   and eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION andnot

;-------------------------------------------------------------------------------
; Opcode 583 - setbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION setbit
   bts eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION setbit

;-------------------------------------------------------------------------------
; Opcode 584 - notand (REG)
;-------------------------------------------------------------------------------
INSTRUCTION notand
   not eax
   and eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION notand

;-------------------------------------------------------------------------------
; Opcode 58b - ornot (REG)
;-------------------------------------------------------------------------------
INSTRUCTION ornot
   not ecx
   or eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION ornot

;-------------------------------------------------------------------------------
; Opcode 58f - alterbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION alterbit
   test [ebp+OFF_FLAGS], byte 2
   jz alterbit_clear
   bts eax, ecx
   jmp alterbit_done
alterbit_clear:
   btr eax, ecx
alterbit_done:
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION alterbit

;-------------------------------------------------------------------------------
; Opcode 58a - not (REG)
;-------------------------------------------------------------------------------
INSTRUCTION not
   not ecx
   mov [ebp+OFF_REGS+ebx*4], ecx
END_INSTRUCTION not

;-------------------------------------------------------------------------------
; Opcode 58c - clrbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION clrbit
   btr eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION clrbit

;-------------------------------------------------------------------------------
; Opcode 58a - chkbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION chkbit
   bt eax, ecx
   mov [ebp+OFF_FLAGS], byte 2
   jc chkbit_set
   mov [ebp+OFF_FLAGS], byte 0
chkbit_set:
END_INSTRUCTION chkbit

;-------------------------------------------------------------------------------
; Opcode 590 - addo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION addo
   add eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION addo

;-------------------------------------------------------------------------------
; Opcode 591 - addi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION addi
   add eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION addi

;-------------------------------------------------------------------------------
; Opcode 592 - subo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION subo
   sub eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION subo

;-------------------------------------------------------------------------------
; Opcode 593 - subi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION subi
   sub eax, ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION subi

;-------------------------------------------------------------------------------
; Opcode 598 - shro (REG)
;-------------------------------------------------------------------------------
INSTRUCTION shro
   shr eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION shro

;-------------------------------------------------------------------------------
; Opcode 59a - shrdi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION shrdi
   ; FIXME - negative rounding error here (see manual)
   sar eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION shrdi

;-------------------------------------------------------------------------------
; Opcode 59b - shri (REG)
;-------------------------------------------------------------------------------
INSTRUCTION shri
   ; FIXME - negative rounding error here?
   sar eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION shri

;-------------------------------------------------------------------------------
; Opcode 59c - shlo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION shlo
   shl eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION shlo

;-------------------------------------------------------------------------------
; Opcode 59d - rotate (REG)
;-------------------------------------------------------------------------------
INSTRUCTION rotate
   rol eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION rotate

;-------------------------------------------------------------------------------
; Opcode 59e - shli (REG)
;-------------------------------------------------------------------------------
INSTRUCTION shli
   shl eax, cl
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION shli

;-------------------------------------------------------------------------------
; Opcode 5a0 - cmpo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpo
   cmp ecx, eax
   jb cmpo_below
   je cmpo_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpo_done

align 4
cmpo_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpo_done

align 4
cmpo_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpo_done:
END_INSTRUCTION cmpo

;-------------------------------------------------------------------------------
; Opcode 5a1 - cmpi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpi
   cmp ecx, eax
   jl cmpi_below
   je cmpi_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpi_done

align 4
cmpi_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpi_done

align 4
cmpi_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpi_done:
END_INSTRUCTION cmpi

;-------------------------------------------------------------------------------
; Opcode 5a2 - concmpo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION concmpo
; FIXME!
END_INSTRUCTION concmpo

;-------------------------------------------------------------------------------
; Opcode 5a3 - concmpi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION concmpi
; FIXME!
END_INSTRUCTION concmpi

;-------------------------------------------------------------------------------
; Opcode 5a4 - cmpinco (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpinco
   cmp ecx, eax
   jb cmpinco_below
   je cmpinco_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpinco_done

align 4
cmpinco_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpinco_done

align 4
cmpinco_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpinco_done:
   inc eax
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION cmpinco

;-------------------------------------------------------------------------------
; Opcode 5a5 - cmpinci (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpinci
   cmp ecx, eax
   jl cmpinci_below
   je cmpinci_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpinci_done

align 4
cmpinci_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpinci_done

align 4
cmpinci_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpinci_done:
   inc eax
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION cmpinci

;-------------------------------------------------------------------------------
; Opcode 5a6 - cmpdeco (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpdeco
   cmp ecx, eax
   jb cmpdeco_below
   je cmpdeco_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpdeco_done

align 4
cmpdeco_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpdeco_done

align 4
cmpdeco_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpdeco_done:
   inc eax
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION cmpdeco

;-------------------------------------------------------------------------------
; Opcode 5a7 - cmpdeci (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpdeci
   cmp ecx, eax
   jl cmpdeci_below
   je cmpdeci_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpdeci_done

align 4
cmpdeci_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpdeci_done

align 4
cmpdeci_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpdeci_done:
   inc eax
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION cmpdeci

;-------------------------------------------------------------------------------
; Opcode 5b0 - addc (REG)
;-------------------------------------------------------------------------------
INSTRUCTION addc
   mov [ebp+OFF_FLAGS], ebx
   shr ebx, 2
   adc eax, ecx
   pushf
   pop edx
   and edx, 0x801
   shl dh, 5
   rol edx, 1
   mov [ebp+OFF_REGS+ebx*4], eax
   mov [ebp+OFF_FLAGS], edx
END_INSTRUCTION addc

;-------------------------------------------------------------------------------
; Opcode 5b2 - subc (REG)
;-------------------------------------------------------------------------------
INSTRUCTION subc
   mov [ebp+OFF_FLAGS], ebx
   shr ebx, 2
   sbb eax, ecx
   pushf
   pop edx
   and edx, 0x801
   shl dh, 5
   rol edx, 1
   mov [ebp+OFF_REGS+ebx*4], eax
   mov [ebp+OFF_FLAGS], edx
END_INSTRUCTION subc

;-------------------------------------------------------------------------------
; Opcode 5cc - mov (REG)
;-------------------------------------------------------------------------------
INSTRUCTION mov
   mov [ebp+OFF_REGS+ebx*4], ecx
END_INSTRUCTION mov

;-------------------------------------------------------------------------------
; Opcode 5dc - movl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movl
; FIXME - put in the NOEXPAND stuff
   mov eax, [ebp+OFF_REGS+ecx*4]
   mov edx, [ebp+OFF_REGS+ecx*4+4]
   mov [ebp+OFF_REGS+ebx*4], eax
   mov [ebp+OFF_REGS+ebx*4+4], edx
END_INSTRUCTION movl

;-------------------------------------------------------------------------------
; Opcode 5ec - movt (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movt
; FIXME - put in the NOEXPAND stuff
   mov eax, [ebp+OFF_REGS+ecx*4]
   mov edx, [ebp+OFF_REGS+ecx*4+4]
   mov edi, [ebp+OFF_REGS+ecx*4+8]
   mov [ebp+OFF_REGS+ebx*4], eax
   mov [ebp+OFF_REGS+ebx*4+4], edx
   mov [ebp+OFF_REGS+ebx*4+8], edi
END_INSTRUCTION movt

;-------------------------------------------------------------------------------
; Opcode 5fc - movq (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movq
; FIXME - put in the NOEXPAND stuff
   mov eax, [ebp+OFF_REGS+ecx*4]
   mov edx, [ebp+OFF_REGS+ecx*4+4]
   mov edi, [ebp+OFF_REGS+ecx*4+8]
   mov [ebp+OFF_REGS+ebx*4], eax
   mov eax, [ebp+OFF_REGS+ecx*4+12]
   mov [ebp+OFF_REGS+ebx*4+4], edx
   mov [ebp+OFF_REGS+ebx*4+8], edi
   mov [ebp+OFF_REGS+ebx*4+8+12], edi
END_INSTRUCTION movq

;-------------------------------------------------------------------------------
; Opcode 600 - synmov (REG)
;-------------------------------------------------------------------------------
INSTRUCTION synmov
   mov [ebp+OFF_FLAGS], byte 2
   mov edi, eax
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edx -> [addr]

   ; FIXME - check ICR here
END_INSTRUCTION synmov

;-------------------------------------------------------------------------------
; Opcode 602 - synmovq (REG)
;-------------------------------------------------------------------------------
INSTRUCTION synmovq
   mov [ebp+OFF_FLAGS], byte 2
   mov edi, eax
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edx -> [addr]
   add eax, 4
   add ecx, 4

   mov edi, eax
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edx -> [addr]
   add eax, 4
   add ecx, 4

   mov edi, eax
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edx -> [addr]
   add eax, 4
   add ecx, 4

   mov edi, eax
	call [ebp+OFF_READMEM]   ; [addr] -> edx
   mov edi, ecx
	call [ebp+OFF_WRITEMEM]   ; edx -> [addr]

	call CheckIAC
END_INSTRUCTION synmovq

;-------------------------------------------------------------------------------
; Opcode 641 - scanbit (REG)
;-------------------------------------------------------------------------------
INSTRUCTION scanbit
   ; search for MSB
   bsr eax, ecx
   jnz scanbit_ok

   ; indicate failure
   mov eax, 0xffffffff
   mov [ebp+OFF_FLAGS], byte 0
   jmp scanbit_finish
scanbit_ok:
   mov [ebp+OFF_FLAGS], byte 2
scanbit_finish:
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION scanbit

;-------------------------------------------------------------------------------
; Opcode 645 - modac (REG)
;-------------------------------------------------------------------------------
INSTRUCTION modac
   ; FIXME!!
END_INSTRUCTION modac

;-------------------------------------------------------------------------------
; Opcode 655 - modpc (REG)
;-------------------------------------------------------------------------------
INSTRUCTION modpc
   ; FIXME!!
END_INSTRUCTION modpc

;-------------------------------------------------------------------------------
; Opcode 66d - flushreg (REG)
;-------------------------------------------------------------------------------
INSTRUCTION flushreg
   ; FIXME - write this
END_INSTRUCTION flushreg

;-------------------------------------------------------------------------------
; Opcode 671 - ediv (REG)
;-------------------------------------------------------------------------------
INSTRUCTION ediv
   mov edx, [ebp+OFF_REGS+eax*4]
   mov eax, [ebp+OFF_REGS+eax*4+4]
   div ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION ediv

;-------------------------------------------------------------------------------
; Opcode 674 - cvtir (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cvtir
   ; FIXME!
END_INSTRUCTION cvtir

;-------------------------------------------------------------------------------
; Opcode 685 - cmpr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmpr
; FIXME! - do this
END_INSTRUCTION cmpr

;-------------------------------------------------------------------------------
; Opcode 688 - sqrtr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION sqrtr
   ; FIXME!
END_INSTRUCTION sqrtr

;-------------------------------------------------------------------------------
; Opcode 68a - logbnr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION logbnr
   ; FIXME!
END_INSTRUCTION logbnr

;-------------------------------------------------------------------------------
; Opcode 695 - cmprl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cmprl
; FIXME! - do this
END_INSTRUCTION cmprl

;-------------------------------------------------------------------------------
; Opcode 6c0 - cvtri (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cvtri
   ; FIXME!
END_INSTRUCTION cvtri

;-------------------------------------------------------------------------------
; Opcode 6c2 - cvtzri (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cvtzri
   ; FIXME!
END_INSTRUCTION cvtzri

;-------------------------------------------------------------------------------
; Opcode 6c3 - cvtzril (REG)
;-------------------------------------------------------------------------------
INSTRUCTION cvtzril
   ; FIXME!
END_INSTRUCTION cvtzril

;-------------------------------------------------------------------------------
; Opcode 6c9 - movr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movr
   ; FIXME!
END_INSTRUCTION movr

;-------------------------------------------------------------------------------
; Opcode 6d9 - movrl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movrl
   ; FIXME!
END_INSTRUCTION movrl

;-------------------------------------------------------------------------------
; Opcode 6e1 - movre (REG)
;-------------------------------------------------------------------------------
INSTRUCTION movre
   ; FIXME!
END_INSTRUCTION movre

;-------------------------------------------------------------------------------
; Opcode 701 - mulo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION mulo
   mul ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION mulo

;-------------------------------------------------------------------------------
; Opcode 708 - remo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION remo
   xor edx, edx
   div ecx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION remo

;-------------------------------------------------------------------------------
; Opcode 70b - divo (REG)
;-------------------------------------------------------------------------------
INSTRUCTION divo
   xor edx, edx
   div ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION divo

;-------------------------------------------------------------------------------
; Opcode 741 - muli (REG)
;-------------------------------------------------------------------------------
INSTRUCTION muli
   imul ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION muli

;-------------------------------------------------------------------------------
; Opcode 748 - remi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION remi
   xor edx, edx
   idiv ecx
   mov [ebp+OFF_REGS+ebx*4], edx
END_INSTRUCTION remi

;-------------------------------------------------------------------------------
; Opcode 74b - divi (REG)
;-------------------------------------------------------------------------------
INSTRUCTION divi
   cdq
   idiv ecx
   mov [ebp+OFF_REGS+ebx*4], eax
END_INSTRUCTION divi

;-------------------------------------------------------------------------------
; Opcode 78b - divr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION divr
   ; FIXME!
END_INSTRUCTION divr

;-------------------------------------------------------------------------------
; Opcode 79b - divrl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION divrl
   ; FIXME!
END_INSTRUCTION divrl

;-------------------------------------------------------------------------------
; Opcode 78c - mulr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION mulr
   ; FIXME!
END_INSTRUCTION mulr

;-------------------------------------------------------------------------------
; Opcode 78d - subr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION subr
   ; FIXME!
END_INSTRUCTION subr

;-------------------------------------------------------------------------------
; Opcode 78f - addr (REG)
;-------------------------------------------------------------------------------
INSTRUCTION addr
   ; FIXME!
END_INSTRUCTION addr

;-------------------------------------------------------------------------------
; Opcode 79c - mulrl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION mulrl
   ; FIXME!
END_INSTRUCTION mulrl

;-------------------------------------------------------------------------------
; Opcode 79f - addrl (REG)
;-------------------------------------------------------------------------------
INSTRUCTION addrl
   ; FIXME!
END_INSTRUCTION addrl


;-------------------------------------------------------------------------------
; Opcode 8 - b (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION b
   lea esi, [esi+eax-4]
END_INSTRUCTION b

;-------------------------------------------------------------------------------
; Opcode 9 - call (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION call
   ; FIXME - write this
END_INSTRUCTION call

;-------------------------------------------------------------------------------
; Opcode b - bal (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION bal
	mov [ebp+OFF_REGS+30*4], esi
   lea esi, [esi+eax-4]
END_INSTRUCTION bal

;-------------------------------------------------------------------------------
; Opcode a - ret (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION ret
   ; FIXME - write this
END_INSTRUCTION ret

;-------------------------------------------------------------------------------
; Opcode 10 - bno (CTRL)
;-------------------------------------------------------------------------------
align 16
INSTRUCTION bno
   test [ebp+OFF_FLAGS], byte 7
   jnz bno_skip
   lea esi, [esi+eax-4]
bno_skip:
END_INSTRUCTION bno

;-------------------------------------------------------------------------------
; Opcode 11 - bg (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION bg
   test [ebp+OFF_FLAGS], byte 1
   jz bg_skip
   lea esi, [esi+eax-4]
bg_skip:
END_INSTRUCTION bg

;-------------------------------------------------------------------------------
; Opcode 12 - be (CTRL)
;-------------------------------------------------------------------------------
align 16
INSTRUCTION be
   test [ebp+OFF_FLAGS], byte 2
   jz be_skip
   lea esi, [esi+eax-4]
be_skip:
END_INSTRUCTION be

;-------------------------------------------------------------------------------
; Opcode 13 - bge (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION bge
   test [ebp+OFF_FLAGS], byte 3
   jz bge_skip
   lea esi, [esi+eax-4]
bge_skip:
END_INSTRUCTION bge

;-------------------------------------------------------------------------------
; Opcode 14 - bl (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION bl
   test [ebp+OFF_FLAGS], byte 4
   jz bl_skip
   lea esi, [esi+eax-4]
bl_skip:
END_INSTRUCTION bl

;-------------------------------------------------------------------------------
; Opcode 15 - bne (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION bne
   test [ebp+OFF_FLAGS], byte 5
   jz bne_skip
   lea esi, [esi+eax-4]
bne_skip:
END_INSTRUCTION bne

;-------------------------------------------------------------------------------
; Opcode 16 - ble (CTRL)
;-------------------------------------------------------------------------------
INSTRUCTION ble
   test [ebp+OFF_FLAGS], byte 6
   jz ble_skip
   lea esi, [esi+eax-4]
ble_skip:
END_INSTRUCTION ble

;-------------------------------------------------------------------------------
; Opcode 22 - teste (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION teste
   xor edx, edx
   test [ebp+OFF_FLAGS], byte 2
   setnz dl
   mov [ebp+OFF_REGS+ecx*4], edx
END_INSTRUCTION teste

;-------------------------------------------------------------------------------
; Opcode 24 - testl (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION testl
   xor edx, edx
   test [ebp+OFF_FLAGS], byte 4
   setnz dl
   mov [ebp+OFF_REGS+ecx*4], edx
END_INSTRUCTION testl

;-------------------------------------------------------------------------------
; Opcode 25 - testne (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION testne
   xor edx, edx
   test [ebp+OFF_FLAGS], byte 5
   setnz dl
   mov [ebp+OFF_REGS+ecx*4], edx
END_INSTRUCTION testne

;-------------------------------------------------------------------------------
; Opcode 26 - testle (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION testle
   xor edx, edx
   test [ebp+OFF_FLAGS], byte 6
   setnz dl
   mov [ebp+OFF_REGS+ecx*4], edx
END_INSTRUCTION testle

;-------------------------------------------------------------------------------
; Opcode 30 - bbc (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION bbc
   bt eax, ecx
   jc bbc_set
   mov [ebp+OFF_FLAGS], byte 2
   lea esi, [esi+ebx-4]
   jmp bbc_done

align 4
bbc_set:
   mov [ebp+OFF_FLAGS], byte 0
bbc_done:
END_INSTRUCTION bbc

;-------------------------------------------------------------------------------
; Opcode 31 - cmpobg (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpobg
   cmp ecx, eax
   jb cmpobg_less
   je cmpobg_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpobg_done

align 4
cmpobg_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpobg_done

align 4
cmpobg_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpobg_done:
   test [ebp+OFF_FLAGS], byte 1
   jz cmpobg_skip
   lea esi, [esi+ebx-4]
cmpobg_skip:
END_INSTRUCTION cmpobg

;-------------------------------------------------------------------------------
; Opcode 32 - cmpobe (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpobe
   cmp ecx, eax
   jb cmpobe_below
   je cmpobe_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpobe_done

align 4
cmpobe_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpobe_done

align 4
cmpobe_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpobe_done:
   test [ebp+OFF_FLAGS], byte 2
   jz cmpobe_skip
   lea esi, [esi+ebx-4]
cmpobe_skip:
END_INSTRUCTION cmpobe

;-------------------------------------------------------------------------------
; Opcode 33 - cmpobge (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpobge
   cmp ecx, eax
   jb cmpobge_below
   je cmpobge_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpobge_done

align 4
cmpobge_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpobge_done

align 4
cmpobge_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpobge_done:
   test [ebp+OFF_FLAGS], byte 3
   jz cmpobge_skip
   lea esi, [esi+ebx-4]
cmpobge_skip:
END_INSTRUCTION cmpobge

;-------------------------------------------------------------------------------
; Opcode 34 - cmpobl (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpobl
   cmp ecx, eax
   jb cmpobl_below
   je cmpobl_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpobl_done

align 4
cmpobl_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpobl_done

align 4
cmpobl_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpobl_done:
   test [ebp+OFF_FLAGS], byte 4
   jz cmpobl_skip
   lea esi, [esi+ebx-4]
cmpobl_skip:
END_INSTRUCTION cmpobl

;-------------------------------------------------------------------------------
; Opcode 35 - cmpobne (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpobne
   cmp ecx, eax
   jb cmpobne_below
   je cmpobne_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpobne_done

align 4
cmpobne_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpobne_done

align 4
cmpobne_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpobne_done:
   test [ebp+OFF_FLAGS], byte 5
   jz cmpobne_skip
   lea esi, [esi+ebx-4]
cmpobne_skip:
END_INSTRUCTION cmpobne

;-------------------------------------------------------------------------------
; Opcode 36 - cmpoble (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpoble
   cmp ecx, eax
   jb cmpoble_below
   je cmpoble_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpoble_done

align 4
cmpoble_below:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpoble_done

align 4
cmpoble_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpoble_done:
   test [ebp+OFF_FLAGS], byte 6
   jz cmpoble_skip
   lea esi, [esi+ebx-4]
cmpoble_skip:
END_INSTRUCTION cmpoble

;-------------------------------------------------------------------------------
; Opcode 37 - bbs (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION bbs
   bt eax, ecx
   jc bbs_set
   mov [ebp+OFF_FLAGS], byte 0
   jmp bbs_done

align 4
bbs_set:
   mov [ebp+OFF_FLAGS], byte 2
   lea esi, [esi+ebx-4]
bbs_done:
END_INSTRUCTION bbs

;-------------------------------------------------------------------------------
; Opcode 39 - cmpibg (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpibg
   cmp ecx, eax
   jl cmpibg_less
   je cmpibg_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpibg_done

align 4
cmpibg_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpibg_done

align 4
cmpibg_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpibg_done:
   test [ebp+OFF_FLAGS], byte 1
   jz cmpibg_skip
   lea esi, [esi+ebx-4]
cmpibg_skip:
END_INSTRUCTION cmpibg

;-------------------------------------------------------------------------------
; Opcode 3a - cmpibe (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpibe
   cmp ecx, eax
   jl cmpibe_less
   je cmpibe_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpibe_done

align 4
cmpibe_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpibe_done

align 4
cmpibe_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpibe_done:
   test [ebp+OFF_FLAGS], byte 2
   jz cmpibe_skip
   lea esi, [esi+ebx-4]
cmpibe_skip:
END_INSTRUCTION cmpibe

;-------------------------------------------------------------------------------
; Opcode 3b - cmpibge (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpibge
   cmp ecx, eax
   jl cmpibge_less
   je cmpibge_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpibge_done

align 4
cmpibge_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpibge_done

align 4
cmpibge_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpibge_done:
   test [ebp+OFF_FLAGS], byte 3
   jz cmpibge_skip
   lea esi, [esi+ebx-4]
cmpibge_skip:
END_INSTRUCTION cmpibge

;-------------------------------------------------------------------------------
; Opcode 3c - cmpibl (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpibl
   cmp ecx, eax
   jl cmpibl_less
   je cmpibl_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpibl_done

align 4
cmpibl_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpibl_done

align 4
cmpibl_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpibl_done:
   test [ebp+OFF_FLAGS], byte 4
   jz cmpibl_skip
   lea esi, [esi+ebx-4]
cmpibl_skip:
END_INSTRUCTION cmpibl

;-------------------------------------------------------------------------------
; Opcode 3d - cmpibne (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpibne
   cmp ecx, eax
   jl cmpibne_less
   je cmpibne_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpibne_done

align 4
cmpibne_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpibne_done

align 4
cmpibne_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpibne_done:
   test [ebp+OFF_FLAGS], byte 5
   jz cmpibne_skip
   lea esi, [esi+ebx-4]
cmpibne_skip:
END_INSTRUCTION cmpibne

;-------------------------------------------------------------------------------
; Opcode 3e - cmpible (COBR)
;-------------------------------------------------------------------------------
INSTRUCTION cmpible
   cmp ecx, eax
   jl cmpible_less
   je cmpible_equal
   mov [ebp+OFF_FLAGS], byte 1
   jmp cmpible_done

align 4
cmpible_less:
   mov [ebp+OFF_FLAGS], byte 4
   jmp cmpible_done

align 4
cmpible_equal:
   mov [ebp+OFF_FLAGS], byte 2
cmpible_done:
   test [ebp+OFF_FLAGS], byte 6
   jz cmpible_skip
   lea esi, [esi+ebx-4]
cmpible_skip:
END_INSTRUCTION cmpible

;-------------------------------------------------------------------------------
