#include "virtua.h"

#define SCALE 8

TextureViewer::TextureViewer(Model2 *emu)
 : Window("TextureViewer", W_CLOSE, 4096/SCALE, 2048/SCALE)
{
   log->Print("TextureViewer: started.");
   this->emu = emu;
   SetTitle("Texture viewer");
}

TextureViewer::~TextureViewer()
{
   log->Print("TextureViewer: ended.");
   emu->textureviewer = NULL;
}

static void Render(BITMAP *bmp, iWORD *p, int x,int y, int w,int h)
{
   int tx,tw,v;
   iWORD c;

   w /= 2;
   h /= 2;
   do {
      tx = x;
      tw = w;
      do {
         c = *p;
         p += SCALE;
         v = (c >> 8) & 0xf0;
         putpixel(bmp, tx,   y,   makecol(v,v,v));
         v = c & 0xf0;
         putpixel(bmp, tx,   y+1, makecol(v,v,v));
         v = (c >> 4) & 0xf0;
         putpixel(bmp, tx+1, y,   makecol(v,v,v));
         v = (c << 4) & 0xf0;
         putpixel(bmp, tx+1, y+1, makecol(v,v,v));
         tx += 2;
      } while(--tw);
      p += w * SCALE*(SCALE-1);
      y += 2;
   } while(--h);
}

void TextureViewer::Draw(BITMAP *bmp)
{
   int w,h;
   w = bmp->w / 4;
   h = bmp->h / 2;
   Render(bmp, &(emu->TEXTURE[0x000000]), 0,   0, w, h);
   Render(bmp, &(emu->TEXTURE[0x040000]), w,   0, w, h);
   Render(bmp, &(emu->TEXTURE[0x080000]), w*2, 0, w, h);
   Render(bmp, &(emu->TEXTURE[0x0c0000]), w*3, 0, w, h);

   Render(bmp, &(emu->TEXTURE[0x100000]), 0,   h, w, h);
   Render(bmp, &(emu->TEXTURE[0x140000]), w,   h, w, h);
   Render(bmp, &(emu->TEXTURE[0x180000]), w*2, h, w, h);
   Render(bmp, &(emu->TEXTURE[0x1c0000]), w*3, h, w, h);
   RequestRedraw();
}
