/* small util to view tile graphics data 
 * needs RAM dump from Virtua to exist
 */

#include <stdio.h>
#include <allegro.h>

unsigned short ROM[0x40000];
unsigned short PAL[0x2000];
int tile, thistile, shift;
int width;

int Pal(int c)
{
   int r,g,b;
   unsigned short val;
   val = PAL[(thistile >> shift) * 16+c];
   r = val & 31;
   g = (val >> 5) & 31;
   b = (val >> 10) & 31;
   return makecol(r*8, g*8, b*8);
}

void DrawWord(int x, int y, unsigned short c)
{
   putpixel(screen, x,   y, Pal((c >> 12) & 0x000f));
   putpixel(screen, x+1, y, Pal((c >>  8) & 0x000f));
   putpixel(screen, x+2, y, Pal((c >>  4) & 0x000f));
   putpixel(screen, x+3, y, Pal( c        & 0x000f));
}

void Draw(void)
{
   int y,dy,x;
   unsigned short c;
   int offset = tile*16;
   thistile = tile;
   for (y=0;y<SCREEN_H;y+=8)
   {
      for (x=0;x<width;x+=8)
      {
         for (dy=0;dy<8;dy++)
         {
            c = ROM[offset++];
            DrawWord(x, y+dy, c);
            c = ROM[offset++];
            DrawWord(x+4, y+dy, c);
         }
         thistile++;
      }
   }
}

int main()
{
   FILE *f;
   int n;

   allegro_init();
   install_keyboard();
   set_color_depth(16);
   set_gfx_mode(GFX_AUTODETECT,320,200,0,0);
   f = fopen("ram108.bin", "rb");
   fread(&ROM[0], 1, 0x80000, f);
   fclose(f);
   f = fopen("ram180.bin", "rb");
   fread(&PAL[0], 1, 0x2000, f);
   fclose(f);

   tile = 0;
   shift = 7;
   n = SCREEN_W/8;
   width = SCREEN_W;
   while(!key[KEY_ESC])
   {
      vsync();
      Draw();
      vsync();
      textprintf(screen, font, 0,0,makecol(255,255,255), "%i", shift);
      if (key[KEY_DOWN]) tile+=n;
      if (key[KEY_UP]) tile-=n;
      if (key[KEY_LEFT]) shift--;
      if (key[KEY_RIGHT]) shift++;
      if (key[KEY_PGUP]) width -= 8;
      if (key[KEY_PGDN]) width += 8;
      if (tile < 0) tile = 0;
      if (shift < 0) shift = 0;
   }
   return 0;
}
