#include <windows.h>
#include "wavemix.h"
#include "resource.h"
#include "mz80.h"
#include <mmsystem.h>

HANDLE ghMixSession;
LPMIXWAVE glpMix1;
LPMIXWAVE glpMix2;
LPMIXWAVE glpMix3;
LPMIXWAVE glpMix4;
LPMIXWAVE glpMix5;
LPMIXWAVE glpMix6;
LPMIXWAVE glpMix7;
LPMIXWAVE glpMix8;
LPMIXWAVE glpMix9;

static char szClassName[] = "Invaders";
static HINSTANCE hInst = NULL;
HWND hWnd;

int xpos;

int game;
int vsize=1; //1x1 or 2x2
BOOL joystick=TRUE;
HMENU hmenu;

BOOL sound=TRUE;		// Indicates if sound is available
BOOL running=FALSE;		// This indicates if a game is running now

BOOL CALLBACK AboutDlgProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam );
int ReadROMS(char *name,int offset,int length);

int invmain(void);
int earthmain(void);
int spaceattack(void);
int onemain(void);
int cvmain(void);
int invrvnge(void);
int invdelux(void);

BOOL bo_QueryValid;

__int64 cu_QueryFreq,cu_TimeThen,cu_TimeNow;

UINT32 dwResult = 0;
UINT32 dwDisplayInterval = 0;
UINT32 dwIntTotal = 0;
static struct mz80context mz80;
static UINT8 bInvadersPlayer = 0x00;
static UINT8 bInvadersDipswitch = 0x00;

BOOL key_1,key_2,key_3,key_left,key_right,key_control;

// Invaders global variables

static UINT32 iInvadersShiftData1, iInvadersShiftData2 , iInvadersShiftAmount;
static UINT8 flip = 1;

static void InvadersOut(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite);
static void NothingWrite(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite);
static UINT16 InvadersShiftDataRead(UINT16 port, struct z80PortRead *pPR);
static UINT16 InvadersPlayerRead(UINT16 port, struct z80PortRead *pPR);
static UINT16 InvadersDipswitchRead(UINT16 port, struct z80PortRead *pPR);
static void InvadersShiftAmountWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersShiftDataWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersSoundPort3Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW);
static void InvadersSoundPort5Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW);

// Invaders read/write structures

struct MemoryWriteByte sInvadersWrite[] =
{
	{0x0000, 0x1FFF, NothingWrite},
   	{0x2400, 0x3FFF, InvadersOut},
	{0x4000, 0x57ff, NothingWrite},
	{-1, 	 -1, 	 NULL}
};

struct MemoryReadByte sInvadersRead[] =
{
	{-1, -1, NULL}
};

struct z80PortRead sInvadersPortRead[] =
{
	{ 0x0000, 0x0002, InvadersPlayerRead, NULL },
	{ 0x0002, 0x0002, InvadersDipswitchRead, NULL },
	{ 0x0003, 0x0003, InvadersShiftDataRead, NULL },
	{-1,	  -1,	  NULL}
};

struct z80PortWrite sInvadersPortWrite[] =
{
	{ 0x02, 0x02, InvadersShiftAmountWrite },
   	{ 0x03, 0x03, InvadersSoundPort3Write },
	{ 0x04, 0x04, InvadersShiftDataWrite },
   	{ 0x05, 0x05, InvadersSoundPort5Write },
	{-1,	-1,	NULL}
};


static void InvadersInterrupt(void)
{
	mz80GetContext(&mz80);


//	if (mz80.z80inInterrupt != 0) return;


	if (flip)
		{
		mz80.z80intAddr = 0x08;		// Interrupt address
		mz80SetContext(&mz80);

		mz80int(0);
		}
	else{
		mz80.z80intAddr = 0x10;		// Interrupt address
		mz80SetContext(&mz80);		// Don't do an NMI
		mz80int(0);					// This is an 8080 not a Z80
		}
	flip ^= 1;
}

static void NothingWrite(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite)
{
	// Do nothing! The region is write protected!
}
static void RedrawScreen(void)
{
	// Video RAM write
	UINT32 addr;
	UINT8 data;
	int b,x,y;
	COLORREF c;
	HDC hdc;

//	if (mz80.z80Base[addr] == data) return;
    hdc=GetDC(hWnd);

	// A new update of screen RAM goes here!

	for (addr=0x2400;addr<0x4000;addr++)
	{
    data=mz80.z80Base[addr];
	x=(addr-0x2400)>>5;
	y=(addr-0x2400)&0x1F;
	c=RGB(255,255,255);
	if(y>1 && y<8) c=RGB(0,255,40);
	if(y<2)
	{
		if(x>13 && x<136) c=RGB(0,255,40);
	}
	if(y>23 && y<28) c=RGB(255,0,40);

	for (b=0;b<8;b++)
	{

	  if(vsize==2)
		{
		if(data&0x01)
			{
			 SetPixel(hdc,2*x,2*(256-((y<<3)+b)),c);
			 SetPixel(hdc,2*x,2*(256-((y<<3)+b))+1,c);
			 SetPixel(hdc,2*x+1,2*(256-((y<<3)+b)),c);
			 SetPixel(hdc,2*x+1,2*(256-((y<<3)+b))+1,c);
			}
		    else
			{
			SetPixel(hdc,2*x,2*(256-((y<<3)+b)),0);
			SetPixel(hdc,2*x,2*(256-((y<<3)+b))+1,0);
			SetPixel(hdc,2*x+1,2*(256-((y<<3)+b)),0);
			SetPixel(hdc,2*x+1,2*(256-((y<<3)+b))+1,0);
			}
		}
	  else
		{
		if(data&0x01)
			{
			 SetPixel(hdc,x,256-((y<<3)+b),c);
			}
		    else
			{
			SetPixel(hdc,x,256-((y<<3)+b),0);
			}
		}
		data=data>>1;
	}
	}
	ReleaseDC(hWnd,hdc);
}

static void InvadersOut(UINT32 addr, UINT8 data, struct MemoryWriteByte *pMemWrite)
{
	// Video RAM write

	int b,x,y;
	COLORREF c;
	HDC hdc;

	if (mz80.z80Base[addr] == data) return;
    hdc=GetDC(hWnd);

	// A new update of screen RAM goes here!

    mz80.z80Base[addr] = data;
	x=(addr-0x2400)>>5;
	y=(addr-0x2400)&0x1F;
	c=RGB(255,255,255);
	if(y>1 && y<8) c=RGB(0,255,40);
	if(y<2)
	{
		if(x>13 && x<136) c=RGB(0,255,40);
	}
	if(y>23 && y<28) c=RGB(255,0,40);

	for (b=0;b<8;b++)
	{

	  if(vsize==2)
		{
		if(data&0x01)
			{
			 SetPixel(hdc,2*x,2*(256-((y<<3)+b)),c);
			 SetPixel(hdc,2*x,2*(256-((y<<3)+b))+1,c);
			 SetPixel(hdc,2*x+1,2*(256-((y<<3)+b)),c);
			 SetPixel(hdc,2*x+1,2*(256-((y<<3)+b))+1,c);
			}
		    else
			{
			SetPixel(hdc,2*x,2*(256-((y<<3)+b)),0);
			SetPixel(hdc,2*x,2*(256-((y<<3)+b))+1,0);
			SetPixel(hdc,2*x+1,2*(256-((y<<3)+b)),0);
			SetPixel(hdc,2*x+1,2*(256-((y<<3)+b))+1,0);
			}
		}
	  else
		{
		if(data&0x01)
			{
			 SetPixel(hdc,x,256-((y<<3)+b),c);
			}
		    else
			{
			SetPixel(hdc,x,256-((y<<3)+b),0);
			}
		}
		data=data>>1;
	}
	ReleaseDC(hWnd,hdc);
}

UINT16 InvadersShiftDataRead(UINT16 port, struct z80PortRead *pPR)
{
	return ((((iInvadersShiftData1 << 8) | iInvadersShiftData2)
		<< iInvadersShiftAmount) >> 8) & 0xFF;
}


UINT16 InvadersPlayerRead(UINT16 port, struct z80PortRead *pPR)
{
	if (0 == port)
	{

		return(0xf4);

        }
        if (1 == port)
        {
                bInvadersPlayer=0x81;
				if(key_1) bInvadersPlayer|=0x04;
                if(key_2) bInvadersPlayer|=0x02;
                if(key_3) bInvadersPlayer&=~0x01;
                if(key_left) bInvadersPlayer|=0x20;
                if(key_right) bInvadersPlayer|=0x40;
                if(key_control) bInvadersPlayer|=0x10;
                return(bInvadersPlayer);
        }
        if (2 == port)
        {
                bInvadersPlayer=0x00;
				if(key_left) bInvadersPlayer|=0x20;
                if(key_right) bInvadersPlayer|=0x40;
                if(key_control) bInvadersPlayer|=0x10;
                return(bInvadersPlayer);
        }
	else
		return(bInvadersPlayer);

}

UINT16 InvadersDipswitchRead(UINT16 port, struct z80PortRead *pPR)
{
	return bInvadersDipswitch;
}

static void InvadersShiftAmountWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	iInvadersShiftAmount = data & 0x07;
}

static void InvadersShiftDataWrite(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	iInvadersShiftData2 = iInvadersShiftData1;
	iInvadersShiftData1 = data;
}

static void InvadersSoundPort3Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	static UINT8 bSound = 0;

	MIXPLAYPARAMS MixPlayParams;

	if (!sound) return;

	MixPlayParams.wSize = sizeof(MIXPLAYPARAMS);
	MixPlayParams.hMixSession = ghMixSession;
	MixPlayParams.hWndNotify=NULL;
	MixPlayParams.dwFlags=WMIX_CLEARQUEUE|WMIX_HIPRIORITY;
	MixPlayParams.wLoops=0;

	if (data&1 && ~bSound&1)
	{
		MixPlayParams.iChannel=1;
		MixPlayParams.lpMixWave=glpMix1;
		MixPlayParams.wLoops=0xffff;
                WaveMixPlay(&MixPlayParams);

	}
	if (~data&1 && bSound&1)

                WaveMixFlushChannel(ghMixSession,1,WMIX_NOREMIX);

	if (data&2 && ~bSound&2)
	{
		MixPlayParams.iChannel=2;
		MixPlayParams.lpMixWave=glpMix2;
                WaveMixPlay(&MixPlayParams);

	}
	if (~data&2 && bSound&2)

                WaveMixFlushChannel(ghMixSession,2,WMIX_NOREMIX);

	if (data&4 && ~bSound&4)
	{
		MixPlayParams.iChannel=3;
		MixPlayParams.lpMixWave=glpMix3;
                WaveMixPlay(&MixPlayParams);

	}
	if (~data&4 && bSound&4)

                WaveMixFlushChannel(ghMixSession,3,WMIX_NOREMIX);

	if (data&8 && ~bSound&8)
	{
		MixPlayParams.iChannel=4;
		MixPlayParams.lpMixWave=glpMix4;
                WaveMixPlay(&MixPlayParams);

	}
	if (~data&8 && bSound&8)

                WaveMixFlushChannel(ghMixSession,4,WMIX_NOREMIX);

	bSound = data;

}

static void InvadersSoundPort5Write(UINT16 port, UINT8 data, struct z80PortWrite *pPW)
{
	static UINT8 bSound2 = 0;

	MIXPLAYPARAMS MixPlayParams;

	if (!sound) return;

	MixPlayParams.wSize = sizeof(MIXPLAYPARAMS);
	MixPlayParams.hMixSession = ghMixSession;
	MixPlayParams.hWndNotify=NULL;
	MixPlayParams.dwFlags=WMIX_CLEARQUEUE|WMIX_HIPRIORITY;
	MixPlayParams.wLoops=0;

	if (data&1 && ~bSound2&1)
	{
		MixPlayParams.iChannel=5;
		MixPlayParams.lpMixWave=glpMix5;
                WaveMixPlay(&MixPlayParams);

	}

	if (data&2 && ~bSound2&2)
	{
		MixPlayParams.iChannel=6;
		MixPlayParams.lpMixWave=glpMix6;
                WaveMixPlay(&MixPlayParams);

	}

	if (data&4 && ~bSound2&4)
	{
		MixPlayParams.iChannel=7;
		MixPlayParams.lpMixWave=glpMix7;
                WaveMixPlay(&MixPlayParams);

	}

	if (data&8 && ~bSound2&8)
	{
		MixPlayParams.iChannel=0;
		MixPlayParams.lpMixWave=glpMix8;
                WaveMixPlay(&MixPlayParams);

	}

	if (data&16 && ~bSound2&16)
	{
		MixPlayParams.iChannel=1;
		MixPlayParams.lpMixWave=glpMix9;
                WaveMixPlay(&MixPlayParams);

	}
	if (~data&16 && bSound2&16)

                WaveMixFlushChannel(ghMixSession,1,WMIX_NOREMIX);

	bSound2 = data;
}



void reset_all(void)
{
	// Reset the virtual processor and load in defaults

	mz80reset();

	// WARNING: mz80Reset wipes out the interrupt addresses to the defaults!

	mz80GetContext(&mz80);
	mz80.z80intAddr = 0x08;		// Interrupt address, this will change every cycle
	mz80SetContext(&mz80);

}
void CloseWaveStuff(void)
{
	if (!ghMixSession)
		return;
        WaveMixCloseChannel(ghMixSession,0,WMIX_ALL);

        if (glpMix1) WaveMixFreeWave(ghMixSession,glpMix1);
        if (glpMix2) WaveMixFreeWave(ghMixSession,glpMix2);
        if (glpMix3) WaveMixFreeWave(ghMixSession,glpMix3);
        if (glpMix4) WaveMixFreeWave(ghMixSession,glpMix4);
        if (glpMix5) WaveMixFreeWave(ghMixSession,glpMix5);
        if (glpMix6) WaveMixFreeWave(ghMixSession,glpMix6);
        if (glpMix7) WaveMixFreeWave(ghMixSession,glpMix7);
        if (glpMix8) WaveMixFreeWave(ghMixSession,glpMix8);
        if (glpMix9) WaveMixFreeWave(ghMixSession,glpMix9);

	glpMix1 = glpMix2 = glpMix3 = glpMix4 = glpMix5 = glpMix6 = glpMix7 = glpMix8= glpMix8 = NULL;

        WaveMixCloseSession(ghMixSession);
	ghMixSession=NULL;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpCmdLine, int nCmdShow)
{
   WNDCLASS WndClass;
   HWND hwnd;
   MSG Msg;


   hInst = hInstance;

   WndClass.style         = CS_HREDRAW | CS_VREDRAW;
   WndClass.lpfnWndProc   = WndProc;
   WndClass.cbClsExtra    = 0;
   WndClass.cbWndExtra    = 0;
   WndClass.hInstance     = hInst;
   WndClass.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
   WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
   WndClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
   WndClass.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU1);
   WndClass.lpszClassName = szClassName;



   if(!RegisterClass(&WndClass))
   {
      MessageBox(0, "Window Registration Failed!", "Error!",
         MB_ICONEXCLAMATION | MB_OK );
      return 0;
   }

	if (vsize==1)
		{
   		hwnd = CreateWindow(szClassName,
      "WINVADERS",
      WS_OVERLAPPED | WS_SYSMENU,
      (GetSystemMetrics(SM_CXSCREEN)-230)/2,(GetSystemMetrics(SM_CYSCREEN)-300)/2, 230,300,
      NULL, NULL, hInst, NULL);
	}
	else
	{
   		hwnd = CreateWindow(szClassName,
      "WINVADERS",
      WS_OVERLAPPED | WS_SYSMENU,
      (GetSystemMetrics(SM_CXSCREEN)-454)/2,(GetSystemMetrics(SM_CYSCREEN)-556)/2, 454,556,
      NULL, NULL, hInst, NULL);
	}

   if(hwnd == NULL)
   {
      MessageBox(0, "Window Creation Failed!", "Error!",
         MB_ICONEXCLAMATION | MB_OK);
      return 0;
   }

   hWnd=hwnd;

   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

    while (TRUE)
    {
        if (PeekMessage(&Msg, NULL, 0, 0, PM_NOREMOVE))
        {

		   if (!GetMessage(&Msg, NULL, 0, 0))
				break;
		   {
				TranslateMessage(&Msg);
				DispatchMessage(&Msg);
			}
		}
		else
		{
			if (running)
			{
			dwResult = mz80exec(2000000/60/2);	// Execute roughly 40000 cycles
			dwIntTotal += mz80GetElapsedTicks(0);	// How much emulated time passed?
			dwDisplayInterval += mz80GetElapsedTicks(1);	// Reset our internal counter
			InvadersInterrupt();

			dwResult = mz80exec(2000000/60/2);	// Execute roughly 40000 cycles
			dwIntTotal += mz80GetElapsedTicks(0);	// How much emulated time passed?
			dwDisplayInterval += mz80GetElapsedTicks(1);	// Reset our internal counter
			InvadersInterrupt();

			if (bo_QueryValid)
				{
				QueryPerformanceCounter( &cu_TimeNow);
				while ((cu_TimeThen + cu_QueryFreq > cu_TimeNow) || (cu_TimeNow < cu_TimeThen))
				QueryPerformanceCounter( &cu_TimeNow);
				cu_TimeThen = cu_TimeNow;
				}
			}
		}
	}

   return Msg.wParam;
}


LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	BOOL fActivate;
	char string[20];
	LPJOYINFO jinfo;
	int dummy;
   switch(Message)
   {
      case WM_ACTIVATE:
	   	fActivate = (LOWORD(wParam) != WA_INACTIVE && !(BOOL) HIWORD(wParam));
        WaveMixActivate(ghMixSession, fActivate);
		break;
      case WM_CREATE:
      {
	  	BOOL fErr=FALSE;
		WAVEMIXINFO Info;
		MIXCONFIG config;
		Info.wSize=sizeof(WAVEMIXINFO);
        if (WaveMixGetInfo(&Info))
				sound=FALSE;


		if (sound)
		{
		config.wSize = sizeof(MIXCONFIG);
		config.dwFlags = WMIX_CONFIG_CHANNELS;
		config.wChannels = 2;  // give us stereo!
        if (!(ghMixSession = WaveMixConfigureInit(&config)))
                sound=FALSE;
        glpMix1=WaveMixOpenWave(ghMixSession,"samples\\0.wav",NULL,0);
        glpMix2=WaveMixOpenWave(ghMixSession,"samples\\1.wav",NULL,0);
        glpMix3=WaveMixOpenWave(ghMixSession,"samples\\2.wav",NULL,0);
        glpMix4=WaveMixOpenWave(ghMixSession,"samples\\3.wav",NULL,0);
        glpMix5=WaveMixOpenWave(ghMixSession,"samples\\4.wav",NULL,0);
        glpMix6=WaveMixOpenWave(ghMixSession,"samples\\5.wav",NULL,0);
        glpMix7=WaveMixOpenWave(ghMixSession,"samples\\6.wav",NULL,0);
        glpMix8=WaveMixOpenWave(ghMixSession,"samples\\7.wav",NULL,0);
        glpMix9=WaveMixOpenWave(ghMixSession,"samples\\8.wav",NULL,0);

        fErr=WaveMixOpenChannel(ghMixSession,8,WMIX_OPENCOUNT);

		if (fErr || !(glpMix1 && glpMix2 && glpMix3 && glpMix4 && glpMix5 && glpMix6 && glpMix7 && glpMix8 && glpMix9))
		{
			CloseWaveStuff();
			sound=FALSE;
		}
		}

		  if (QueryPerformanceCounter(&cu_TimeNow))
		  {
    		QueryPerformanceFrequency( &cu_QueryFreq);
    		cu_QueryFreq = cu_QueryFreq / 50 ;//'50Hz
    		bo_QueryValid = TRUE;
  		  }

		// Always best to start out with 0's

		memset(&mz80, 0, sizeof(struct mz80context));

		// Set up interrupt addresses

		mz80.z80MemRead = sInvadersRead;
		mz80.z80MemWrite = sInvadersWrite;
		mz80.z80IoRead = sInvadersPortRead;
		mz80.z80IoWrite = sInvadersPortWrite;

		mz80.z80Base = (UINT8*)malloc(65536);	// Our virtual 64K
		mz80SetContext(&mz80);

		joySetCapture(hwnd,JOYSTICKID1,100,TRUE);

		return TRUE;
      }
      break;
      case WM_KEYDOWN:
		  switch ((int) wParam)
		  {
		  case '1':
				key_1=TRUE;
			  break;
		  case '2':
				key_2=TRUE;
			  break;
		  case '3':
				key_3=TRUE;
			  break;
		  case VK_LEFT:
				key_left=TRUE;
			  break;
		  case VK_RIGHT:
				key_right=TRUE;
			  break;
		  case VK_CONTROL:
				key_control=TRUE;
			  break;
		  }
		  break;
      case WM_KEYUP:
		  switch ((int) wParam)
		  {
		  case '1':
			  key_1=FALSE;
			  break;
		  case '2':
			  key_2=FALSE;
			  break;
		  case '3':
			  key_3=FALSE;
			  break;
		  case VK_LEFT:
			  key_left=FALSE;
			  break;
		  case VK_RIGHT:
			  key_right=FALSE;
			  break;
		  case VK_CONTROL:
			  key_control=FALSE;
			  break;
		  }
		  break;
      case WM_CLOSE:
         DestroyWindow(hwnd);
      break;
      case MM_JOY1MOVE:
		  if (joystick)
			{
			xpos=LOWORD(lParam);
			if (xpos == 32678)
				{
				key_left=FALSE;
				key_right=FALSE;
				}
			if (xpos == 0)
				{
				key_left=TRUE;
				key_right=FALSE;
				}
			if (xpos == 65446)
				{
				key_right=TRUE;
				key_left=FALSE;
				}
		   }
      break;
      case MM_JOY1BUTTONDOWN:
		  if (joystick)
			{
			if (wParam & JOY_BUTTON2)
				key_control=TRUE;
			if (wParam & JOY_BUTTON4)
				key_3=TRUE;
			if (wParam & JOY_BUTTON3)
				key_1=TRUE;
		    }
      break;
      case MM_JOY1BUTTONUP:
		  if (joystick)
			{
				key_control=FALSE;
				key_1=FALSE;
				key_3=FALSE;
			}
      break;
      case WM_DESTROY:
		CloseWaveStuff();
//	   if(hWnd == NULL)
//			MessageBox(0, "Can't Find sound device or .wav files.", "Error!",
//			MB_ICONEXCLAMATION | MB_OK);
        PostQuitMessage(0);
      break;
      case WM_COMMAND:
		  switch(LOWORD(wParam))
		  {
			case ID_FILE_EXIT:
				PostMessage( hWnd, WM_CLOSE, (WPARAM)0, (LPARAM)0 );
			break;

			case ID_HELP_ABOUT:
				DialogBox( hInst, MAKEINTRESOURCE(IDD_DIALOG1), hWnd, (DLGPROC)AboutDlgProc );
			break;

			case ID_JOYSTICK:
				if (joystick)
					{
						joystick=FALSE;
						hmenu=GetMenu(hWnd);
						CheckMenuItem(hmenu,ID_JOYSTICK,MF_BYCOMMAND | MF_UNCHECKED);
					}
				else
					{
						joystick=TRUE;
						hmenu=GetMenu(hWnd);
						CheckMenuItem(hmenu,ID_JOYSTICK,MF_BYCOMMAND | MF_CHECKED);
					}
			break;

			case ID_22:
				vsize=2;
				hmenu=GetMenu(hWnd);
				CheckMenuItem(hmenu,ID_22,MF_CHECKED);
				CheckMenuItem(hmenu,ID_11,MF_UNCHECKED);
				MoveWindow(hWnd,(GetSystemMetrics(SM_CXSCREEN)-454)/2,(GetSystemMetrics(SM_CYSCREEN)-556)/2,454,556,TRUE);
				RedrawScreen();
			break;

			case ID_11:
				vsize=1;
				hmenu=GetMenu(hWnd);
				CheckMenuItem(hmenu,ID_11,MF_CHECKED);
				CheckMenuItem(hmenu,ID_22,MF_UNCHECKED);
				MoveWindow(hWnd,(GetSystemMetrics(SM_CXSCREEN)-230)/2,(GetSystemMetrics(SM_CYSCREEN)-300)/2,230,300,TRUE);
				RedrawScreen();
			break;

			case ID_SPACEINV:
				invmain();
			break;

			case ID_EARTHINV:
				earthinv();
			break;

			case ID_SPACEATT:
				spaceattack();
			break;

			case ID_ALIENINV:
				alieninv();
			break;

			case ID_INVRVNGE:
				invrvnge();
			break;

			case ID_INVDELUX:
				invdelux();
			break;

			case ID_CV:
				cvmain();
			break;

			case ID_INVADERS2:
				invaders2();
			break;

			case ID_COSMICMO:
				cosmicmo();
			break;

		  }
		  break;
      default:
         return DefWindowProc(hwnd, Message, wParam, lParam);
   }
   return 0;
}


int invmain(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;


	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("invaders.h",0x0000,2048);
	Success+=ReadROMS("invaders.g",0x0800,2048);
	Success+=ReadROMS("invaders.f",0x1000,2048);
	Success+=ReadROMS("invaders.e",0x1800,2048);


	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;

	return(0);

}

int earthinv(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("earthinv.h",0x0000,2048);
	Success+=ReadROMS("earthinv.g",0x0800,2048);
	Success+=ReadROMS("earthinv.f",0x1000,2048);
	Success+=ReadROMS("earthinv.e",0x1800,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int spaceattack(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("spaceatt.h",0x0000,2048);
	Success+=ReadROMS("spaceatt.g",0x0800,2048);
	Success+=ReadROMS("spaceatt.f",0x1000,2048);
	Success+=ReadROMS("spaceatt.e",0x1800,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int alieninv(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("1h.bin",0x0000,2048);
	Success+=ReadROMS("1g.bin",0x0800,2048);
	Success+=ReadROMS("1f.bin",0x1000,2048);
	Success+=ReadROMS("1e.bin",0x1800,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int cvmain(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("cv17.bin",0x0000,2048);
	Success+=ReadROMS("cv18.bin",0x0800,2048);
	Success+=ReadROMS("cv19.bin",0x1000,2048);
	Success+=ReadROMS("cv20.bin",0x1800,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int invrvnge(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("invrvnge.h",0x0000,2048);
	Success+=ReadROMS("invrvnge.g",0x0800,2048);
	Success+=ReadROMS("invrvnge.f",0x1000,2048);
	Success+=ReadROMS("invrvnge.e",0x1800,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int invdelux(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;

	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("invdelux.h",0x0000,2048);
	Success+=ReadROMS("invdelux.g",0x0800,2048);
	Success+=ReadROMS("invdelux.f",0x1000,2048);
	Success+=ReadROMS("invdelux.e",0x1800,2048);
	Success+=ReadROMS("invdelux.d",0x4000,2048);

	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;
	return(0);

}
int invaders2(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;


	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("pv.01",0x0000,2048);
	Success+=ReadROMS("pv.02",0x0800,2048);
	Success+=ReadROMS("pv.03",0x1000,2048);
	Success+=ReadROMS("pv.04",0x1800,2048);
	Success+=ReadROMS("pv.05",0x4000,2048);


	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;

	return(0);

}
int cosmicmo(void)
{
   int Success = 0;
   HDC hdc;
   RECT Rect;


	// Load in our ROM images here (sub directory ROMS)...

	Success=ReadROMS("cosmicmo.1",0x0000,0x400);
	Success+=ReadROMS("cosmicmo.2",0x0400,0x400);
	Success+=ReadROMS("cosmicmo.3",0x0800,0x400);
	Success+=ReadROMS("cosmicmo.4",0x0C00,0x400);
	Success+=ReadROMS("cosmicmo.5",0x4000,0x400);
	Success+=ReadROMS("cosmicmo.6",0x4400,0x400);
	Success+=ReadROMS("cosmicmo.7",0x4800,0x400);


	// Clear the screen
    hdc=GetDC(hWnd);

	GetClientRect(hWnd,&Rect);
	FillRect(hdc,&Rect,GetStockObject(BLACK_BRUSH));
	ReleaseDC(hWnd,hdc);

	reset_all();

	if (Success ==0)
		running=TRUE;
	else
		running=FALSE;

	return(0);

}

// ======================================================================
/*
  FUNCTION   : AboutDlgProc

  PARAMETERS : HWND hWnd        -  dialog window handle
               UINT message     -  type of message
               WPARAM wParam    -  additional information
               LPARAM lParam    -  additional information

  PURPOSE    : Processes messages for the About Dialog Box

  RETURNS    : LRESULT

*/
BOOL CALLBACK AboutDlgProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
{
	HWND hWndtemp;
	HFONT hfont;
	switch( Msg )
	{
		case WM_INITDIALOG:
			hWndtemp=GetDlgItem(hWnd,IDC_STATIC1);
			hfont=CreateFont(18,0,0,0,700,1,0,0,0,0,0,0,0,"Arial");

			SendMessage(hWndtemp,WM_SETFONT,(WPARAM)hfont,1);
		break;

		case WM_DESTROY:
			DeleteObject(hfont);
		break;

		case WM_CLOSE:
			PostMessage( hWnd, WM_COMMAND, IDCANCEL, 0l );
		break;

		case WM_COMMAND:
			switch( LOWORD(wParam) )
			{
				case IDOK:
					EndDialog( hWnd, TRUE );
				break;

				case IDCANCEL:
					EndDialog( hWnd, FALSE );
				break;

			}
		break;
		default:
			return FALSE;
		break;
	}
	return TRUE;
}
// End AboutDlgProc

int ReadROMS(char *name,int offset,int length)
{

    HANDLE hFile;
	char fullpath[100];

	strcpy(fullpath,"roms\\");

	strcat(fullpath,name);


   hFile = CreateFile(fullpath, GENERIC_READ, FILE_SHARE_READ, NULL,
      OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
   if(hFile != INVALID_HANDLE_VALUE)
   {
      DWORD dwFileSize;
      dwFileSize = GetFileSize(hFile, NULL);
      if(dwFileSize != 0xFFFFFFFF)
      {
            DWORD dwRead;
            ReadFile(hFile, mz80.z80Base + offset, length, &dwRead, NULL);
      }
      CloseHandle(hFile);
	  return 0;
   }
	else
	{
		strcat(fullpath," not found");
		MessageBox(hWnd,fullpath,"ERROR",MB_OK);
		return 1;
	}

}



