''####################################################################################################
''#                                                                                                  #
''# F.E.E.L. - FrontEnd (Emulator Launcher)                                                          #
''# setup.vbs - check prerequisites/download/start script                                            #
''#                                                                                                  #
''# Copyright © FEELTeam 2016                                                                        #
''#                                                                                                  #
''####################################################################################################

'' Get Windows folders
set WshShell = WScript.CreateObject("WScript.Shell")
strFonts = WshShell.SpecialFolders("Fonts")
strWindows = Left(strFonts, Len(strFonts) - 5)

result = 0

'' Check if .net 3.5 is available on system
strFramework35 = strWindows + "Microsoft.NET\Framework\v3.5"
Set oFSO_35 = CreateObject("Scripting.FileSystemObject")
Do While True
   If not oFSO_35.FolderExists(strFramework35) Then
      result = msgbox(".NET framework 3.5 is missing - Do you want to download it?", vbExclamation+vbYesNoCancel, "FEEL setup - .NET framework 3.5")
      If result=6 Then '' Yes
         Set objOpen35 = WScript.CreateObject("WScript.Shell" )
         objOpen35.Run "https://www.microsoft.com/en-us/download/details.aspx?id=22"
      Else
         If result = 2 Then '' Cancel
            wscript.quit -2
         End If
         result = -1
      End If
      msgbox "Click ok after installing .NET 3.5." , , "FEEL setup - .NET framework 3.5"
   Else
      Exit Do
   End If
Loop

'' Check if XNA 3.1 framework is available on system
Const HKEY_LOCAL_MACHINE = &H80000002
Do While True
   strComputer = "."
   Set objRegistry = GetObject("winmgmts:\\" & strComputer & "\root\default:StdRegProv")
   strKeyPath = "SOFTWARE\Microsoft\XNA\Framework\v3.1"
   strValueName = "Installed"
   objRegistry.GetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,dValue
   If IsNull(dValue) Then '' Key is not there..
       installed = -1
   Else
   	If dValue <> 1 Then '' Key existing, but <> 1
   		installed = -2
   	Else
   		installed = 1
         Exit Do
   	End If
   End If

   If installed <> 1 Then
      result = msgbox("XNA framework 3.1 is missing - Do you want to download it?", vbExclamation+vbYesNoCancel, "FEEL setup - XNA framework 3.1")
      If result = 6 Then '' Yes
         Set objOpenXNA = WScript.CreateObject("WScript.Shell" )
         objOpenXNA.Run "https://www.microsoft.com/en-us/download/details.aspx?id=15163"
      Else
         If result = 2 Then '' Cancel
   	     wscript.quit -2
   	  End If
   	  result = -1
      End If
      msgbox "Click ok after installing XNA." , , "FEEL setup - XNA framework 3.1"
   End If
Loop

If result = 0 Then
	msgbox "Ready to start FEEL: enjoy! ;-)" + vbCrLf + vbCrLf + "PS: next time start FEEL.EXE directly.", , "FEEL setup - Check OK"
   WshShell.Run("""feel.exe""")
End If
wscript.quit result