;
;	this program returns the amount
;	of free space in the tpa.
;	this can be useful when running under
;	fast, despool, ddt, sid, etc.
;
;	version of 8/30/80
;
;
;	by Ron Fowler	
;	   Westland, Mich.
;	   8/24/80
;
;	   fixes and code optimizations by
;	   Keith Petersen
;
	z80
bdos	equ	5
fCnOut	equ	2
fPrint	equ	9

	org	100h
;
base:	jmp	start
Stack$Save	
	dw	0
AddrBios
	dw	0
AddrBdos
	dw	0
msgOvr
	db	' bytes before overlaying the CCP.',13,10,'$'
msgTot
	db	' bytes total TPA space.',13,10,'$'
msgBios
	db	' Location of BIOS=','$'
msgBdos
	db	' Location of BDOS=','$'
msgCCP
	db	' Location of CCP=','$'
msgTPA
	db	' Location of TPA=0100','$'
msgKHex
	db	'K 0x','$'

start
	sspd	Stack$Save

	lxi	sp,stack

	lded	6
	mvi	e,0
	sded	AddrBdos

	lded	1
	mvi	e,0
	sded	AddrBios

	call	NewLine

	lxi	de,msgTPA
	call	printDE
	call	NewLine

	lxi	de,msgBios
	call	printDE
	lhld	AddrBios	;get bios high address
	call	PrintHexHL
	call	NewLine

	lxi	de,msgBdos
	call	printDE
	lhld	AddrBdos	;get bdos high address
	call	PrintHexHL
	call	NewLine

	lxi	de,msgCCP
	call	printDE
	lded	AddrBdos	;get the top of memory
	lxi	H,-(800h) 	;ccp size 
	dad	d		;subtract it, answer left in hl
	call	PrintHexHL
	call	NewLine
	call	NewLine

	lded	AddrBdos	;get the top of memory
	lxi	h,-100h 	;get the start of mem
	dad	d		;subtract it, answer left in hl

	push	hl
	call	PrintSpace
	call	DivHL1024
	call	printDecHL
	lxi	de,msgKHex
	call	PrintDE
	pop	hl

	call	PrintHexHL
	call	PrintSpace
	call	PrintDecHL	;print it

	lxi	de,msgTot
	call	PrintDE

	lded	AddrBdos	;get the top of memory
	lxi	H,-(800h+100h) ;ccp size + tpa
	dad	d		;subtract it, answer left in hl

	push	hl
	call	PrintSpace
	call	DivHL1024
	call	printDecHL
	lxi	de,msgKHex
	call	PrintDE
	pop	hl

	call	PrintHexHL
	call	PrintSpace
	call	PrintDecHL	;print it

	lxi	d,msgOvr
	call	PrintDE

	lspd	Stack$Save	;restore ccp stack
	ret			;back to the ccp
;
;	subroutines
;
; Console output routine
;	prints character in 'a' register
;
co:	push	h
	push	d
	push	b
	mov	e,a		;character to e for CP/M
	mvi	c,fCnOut 	;print console function
	call	bdos		;print character
	pop	b
	pop	d
	pop	h
	ret
;
; Decimal output routine
;	this routine has following
;	entry and external parameters:
;
;	   entry:    hl=binary number to print in decimal
;	   external calls: co routine
;	   ** note...this routine is recursive, and uses
;	   6 bytes of stack for each recursive call, in ad-
;	   dition to any stack space used by the co routine.
;
PrintDecHL: 
decout	push	b
	push	d
	push	h
	lxi	b,-10
	lxi	d,-1
;
decou2: dad	b
	inx	d
	jc	decou2
	lxi	b,10
	dad	b
	xchg
	mov	a,h
	ora	l
	cnz	decout
	mov	a,e
	adi	'0'
	call	co
	pop	h
	pop	d
	pop	b
	ret
;-------------------------
PrintHexHL
	mov	a,h
	call	PrintHex2
	mov	a,l		;get bdos low address
	call	PrintHex2
	ret
;-------------------------
;convert Binary in A to Hex 
HEX2:
HEX2H	db	030h
HEX2L	db	030h
	db	'$'
BIN2HEX:	
	push	a		
	push	a
	ani	0f0h
	rrc
	rrc	
	rrc
	rrc
	cpi	0ah
	jc	notA_FH
	adi	041h-03ah
notA_FH	adi	030h
	sta	HEX2H
	pop	a
	ani	0fh
	cpi	0ah
	jc	notA_FL
	adi	041h-03ah
notA_FL	adi	030h
	sta 	HEX2L
	pop	a
	ret

;-------------------------
PrintHEX2:
	push	de
	call	BIN2HEX
	lxi	de,HEX2
	call	PrintDE
	pop	de
	ret
;-------------------------
PrintHL:
	push	de
	mov	e,l
	mov	d,h
	call	PrintDE
	pop 	de
	ret
;-------------------------
PrintDE:
	push	hl
	push	bc
	push	a
	mvi	c,fPrint
	call	bdos
	pop	a
	pop	bc
	pop	hl
	ret
;-------------------------
NL	db	13,10,'$'
NewLine:
	push	de
	lxi	de,NL
	call	PrintDE
	pop	de
	ret

SPC	db	' ','$'
PrintSpace:
	push	de
	lxi	de,SPC
	call	PrintDE
	pop	de
	ret
;-------------------------
DivHL1024
	push	psw
	mov	a,h
	srlr	a
	srlr	a
	mov	l,a
	mvi	h,0
	pop	psw
	ret
;
stack	equ	$+200	;100 level stack
;
	end
