	z80

true	equ	0ffh
false	equ	0

Special56	equ	false
;Special56	equ	true


nk.sys	equ	62	;system size in K
kdb	equ	1024	;1k
hkdb	equ	kdb/2	;half k
cpm.sz	equ	nk.sys*kdb	;top sys address
td	equ	nk.sys/10	;decimal tens digit
od	equ	nk.sys%10	;decimal ones digit
td.asc	equ	td+&h30		;ascci tens digit
od.asc	equ	od+&h30		;ascii ones digit
bias	equ	20*kdb		;20k
cpm.bs	equ	cpm.sz-bias	;cpm size
ccp	equ	cpm.bs+3400h	;address of ccp
bdos	equ	cpm.bs+3c00h	;address of bdos
bios	equ	cpm.bs+4a00h	;address of bios
	ift 	Special56
xbios	equ	0ec00h		;vacant space
	else
xbios	equ	bios+kdb	;
	endif
tpa	equ	100h		;tpa

;      	LST: 	PUN:	RDR:	CON:	
;	10	00	00	01
;------------------------------------
;00	tty:	tty:	tty:	tty:
;01	crt:	ptp:	ptr:	crt:
;10	lpt:	up1:	ur1:	bat:
;11	ul1:	up2:	ur2:	uc1:

df.iob	equ	10000001b	;def iobyte	
iobyte	equ	3		;addres of iobyte

lb.con	equ	4fh		;last byte entered through con
ll.drv	equ	4		;address of last logged drive
df.drv	equ	0		;def drive =a
sec.sz	equ	080h		;sector size
fmt.sz	equ	0100h		;format buffer size
n.drvs	equ	4		;number of drives1-4

	org	tpa
	jmp	start

cold	equ	xbios+0
init	equ	xbios+3
warm	equ	xbios+6

bios.w	equ	bios+3		;bios warm entry
bios.wa	equ	bios+4		;address in bios warm entry
bios.a	equ	1		;location of bios
xbios.im	equ	300h 	;image of xbios

lf	equ	0ah		;line feed
cr	equ	0dh		;carrige return
cntl.z	equ	1ah		;control z(eof)

msg.alr	db	cr,lf,lf
	text	"xbios Already Installed"
msg.set	db	cr,lf,lf
	text	"CRT"
	db	':'
	text	"=EmuCRT TTY"
	db	':'
	text	"=EmuTTY LST"
	db	':'
	text	"PTP"
	db	':'
	text	"=EmuPrint PTR"
	db	':'
	text	"=ExtFS"
	db	cr,lf
	text	"UC1"
	db	':'
	text	"UP1"
	db	':'
	text	"UR1"
	db	':'
	text	"=SerA UL1"
	db	':'
	text	"UP2"
	db	':'
	text	"UR2"
	db	':'
	text	"=SerB"
	db	cr,lf,lf,'$'	;

msg.ldg	db	cr,lf,lf
	text	"Installing xbios"
	db	cr,lf,lf,'$'	;

msg.wsz	db	cr,lf,lf
	text	"Not a"
sys.td	db	td.asc		;tens digit
sys.od	db	od.asc		;ones digit
	text	"K System"
	db	cr,lf,lf,'$'	;

msg.wos	db	cr,lf,lf
	text	"Not a CPM 2.2 system"
	db	cr,lf,lf,'$'	;

;block	mov	a,m		;
;	stax	d		;
;	inx	h		;
;	inx	d		;
;	dcx	b		;
;	mov	a,b		;
;	ora	c		;
;	jnz	block		;
;	ret			;

start	
	mvi	c,12		;
	call	5		;
	lxi	d,0022h		;CPM 2.2
	call	CDEHL
	jrnz	wrong.os
	
	lhld	bios.a		;get bios location
	lxi	d,bios.w	;assembled bios address
	call	CDEHL
	jrnz	wrong.size	;

	lhld	bios.wa		;actual bios warm address
	lxi	d,warm		;get xbios warm address
	call	CDEHL
	jrz	already

	lxi	d,msg.ldg	;
	call	PrntStr		;
	lxi	d,msg.set	;
	call	PrntStr		;

	lxi	h,xbios.im	;move xbios image to execution address
	lxi	d,xbios		;
	lxi	b,kdb		;
	ldir			;
;	call 	block
	call	cold		;to initialize ctc and type ahead
	jmp	0		;warm boot to enable interrupts

CDEHL	mov	a,h		;
	cmp	d		;
	jrnz	C0001		;
	mov	a,l		;
	cmp	e		;
C0001	ret


wrong.size	
	lxi	d,msg.wsz	;
	jmpr	PrntStr		;

wrong.os	
	lxi	d,msg.wos	;
	jmpr	PrntStr		;

already	
	lxi	d,msg.alr	;
PrntStr	mvi	c,9		;
	call	5		;
	ret			;return to ccp

	end	tpa