	title 'bank & move module for CP/M3 linked BIOS'

	cseg

	public ?move,?xmove,?bank
	extrn @cbnk
	maclib z80
	maclib ports

dbnkD 	db	0ffh		; source bank for DMA
sbnkD	db	0ffh		; destination bank for DMA

?xmove:	mov	a,b	; setup to perform interbank moves
	sta	dbnkD
	mov	a,c
	sta	sbnkD
	ret

?move:
	lda	dbnkD	; check for common move
	cpi	0ffh
	jrz	currentMove
	out	0E3h	; destination bank
	lda	sbnkD
	out	0E2h	; source bank
	jmp	doMove
currentMove:
	lda	@cbnk
	out	0E2h	; source bank
	out	0E3h	; destination bank
doMove:
	mov	a,d	; we are passed source in DE and dest in HL
	out	0e5h	; source high
	mov	a,e
	out	0e4h	; source low
	mov	a,h
	out	0e7h	; dest high
	mov	a,l
	out	0e6h	; dest low
	mov	a,b
	out	0e9h	; count high
	mov	a,c
	out	0e8h	; count low
	; cmd=move s to d, but only to/from common, above boundary
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	dad	bc	; need next addresses in same regs
	xchg	
	dad	bc
	xchg

	mvi	a,0ffh	; indicate common move next
	sta	dbnkD	;
	ret

?bank:
	out 	0c0h	; put new bank select byte
	ret

	end
