// ---------------------------------------------------------------------------
//	class SoundBuffer 
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: soundbuf.cpp,v 1.5 1999/11/26 10:13:25 cisc Exp $

#include "headers.h"
#include "soundbuf.h"
#include "misc.h"

// ---------------------------------------------------------------------------
//	Sound Buffer
//
SoundBuffer::SoundBuffer()
: buffer(0), buffersize(0), ch(0)
{
	fillwhenempty = true;
}

SoundBuffer::~SoundBuffer()
{
	Cleanup();
}

bool SoundBuffer::Init(int nch, int bufsize)
{
	CriticalSection::Lock lock(cs);
	
	delete[] buffer; buffer = 0;
	
	buffersize = bufsize;
	ch = nch;
	read = 0; write = 0;

	if (ch && buffersize > 0)
	{
		buffer = new Sample[ch * buffersize];
		if (!buffer)
			return false;

		memset(buffer, 0, ch * buffersize * sizeof(Sample));
	}
	return true;
}

void SoundBuffer::Cleanup()
{
	CriticalSection::Lock lock(cs);
	
	delete[] buffer; buffer = 0;
}

// ---------------------------------------------------------------------------
//	obt@ɉǉ
//
void SoundBuffer::Put(int samples)
{
	CriticalSection::Lock lock(cs);
	if (buffer)
		PutMain(samples);
}

void SoundBuffer::PutMain(int samples)
{
	// Oobt@̋󂫂vZ
	int free;
	if (read <= write)
		free = buffersize + read - write;
	else
		free = read - write;

	if (!fillwhenempty && (samples > free-1))
	{
		int skip = Min(samples-free+1, buffersize-free);
		free += skip;
		read += skip;
		if (read > buffersize)
			read -= buffersize;
	}
	
	// ނׂf[^ʂvZ
	samples = Min(samples, free-1);
	if (samples > 0)
	{
		// 
		if (buffersize - write >= samples)
		{
			// xŏꍇ
			Mix(buffer + write * ch, samples);
		}
		else
		{
			// Qxɕďꍇ
			Mix(buffer + write * ch, buffersize - write, buffer, samples - (buffersize - write));
		}
		write += samples;
		if (write >= buffersize)
			write -= buffersize;
	}
}

// ---------------------------------------------------------------------------
//	obt@特Ⴄ
//
void SoundBuffer::Get(Sample* dest, int samples)
{
	CriticalSection::Lock lock(cs);
	if (buffer)
	{
		while (samples > 0)
		{
			int xsize = Min(samples, buffersize - read);
			
			int avail;
			if (write >= read)
				avail = write - read;
			else
				avail = buffersize + write - read;

			// sȂǉ
			if (xsize <= avail || fillwhenempty)
			{
				if (xsize > avail)
					PutMain(xsize - avail);
				memcpy(dest, buffer + read * ch, xsize * ch * sizeof(Sample));
				dest += xsize * ch;
				read += xsize;
			}
			else
			{
				if (avail > 0)
				{
					memcpy(dest, buffer + read * ch, avail * ch * sizeof(Sample));
					dest += avail * ch;
					read += avail;
				}
				memset(dest, 0, (xsize - avail) * ch * sizeof(Sample));
				dest += (xsize - avail) * ch;
			}
			
			samples -= xsize;
			if (read >= buffersize)
				read -= buffersize;
		}
	}
}

// ---------------------------------------------------------------------------
//	obt@󂩁Cɋ߂Ԃ?
//
bool SoundBuffer::IsEmpty()
{
	int avail;
	if (write >= read)
		avail = write - read;
	else
		avail = buffersize + write - read;
	
	return avail == 0;
}

