/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

extern byte lcdactive, lcdmode, lcdinc;

void handlelink(byte line);

byte x2_Z80_In(byte Port)
{
	byte v, i;
	
	switch(Port) {
		case 0x00:
			handlelink((~tilnk & pclnk) & 0x03);

			return(0xc0 | (((~tilnk & pclnk) & 0x03) * 5));

		case 0x01:
			updatekb();

			v = 0xFF;
			for (i = 0; i < 7; i++)
				v &= ((keymask >> i) & 0x01)?0xFF:scode[i];

			return(v);

		case 0x02:
			return(port2);

		case 0x03:
			if (port4) {
				port4--;
				return(0x01);
			}

			if (onkey) {
				onkey--;
				return(0x01|(R.IFF1?0:2));
			}

			return(0x08|(R.IFF1?0:2));

		case 0x10:
		  	return(0x40 | lcdmode << 6| lcdactive << 5 | (lcdinc & 3));
		case 0x11:
			return(LCDIn());

	}
	printf("** Experimental ** inimplemented port read: %d\n", Port);
	return(0x00);
}


void x2_Z80_Out(byte Port, byte Value)
{
	extern byte lcdshow;

	switch(Port) {
		case 0x00:
			tilnk = ((((Value>>4) & (Value>>2)) | Value) & 0x03);

			handlelink((~tilnk & pclnk) & 0x03);
			break;

		case 0x01:
			keymask = Value;
			break;

		case 0x02:
			port2 = Value;
			pager[1] = Value & 0x07;
			break;

		case 0x10:
			LCDDriver(Value);
			break;

		case 0x11:
			lcdshow = 1;
			LCDOut(Value);
	}

	return;
}
