/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* >>> Imported */
#include "../../../tools.h"
/* Imported <<< */

extern char *romfile;
extern char *savfile;

#ifdef extlink
void ti68k_close_linkport();
void ti68k_open_linkport();
#endif


void x5_Rezet(byte i)
{
	extern Z80_Regs R;
	extern byte lcdshow;
	FILE *rfile;
	char *fname;

	tilnk = 0;
	pclnk = 0x03;
	dbusstat = DBUS_DISABLED;

	port3 = 100000;
	port6 = 0x40;
	pager[0] = 0x00;
	pager[1] = 0x00;
	pager[2] = 0x09;
	pager[3] = 0x08;
	lcdbuf = mpages + (0x08 * 0x4000) + 0x3C00;

	memset(mpages + 0x08 * 0x4000, 0x00, 0x02 * 0x4000);
	if (i == 0) return;

	fname = savfile ? savfile : ahome("x5.sav");
	if ((rfile = fopen(fname, "rb"))) {
		lcdshow = 1;
		fread(pager, sizeof(byte), 4, rfile);
		fread(&R, sizeof(byte), sizeof(Z80_Regs), rfile);
		fread(mpages + 0x08 * 0x4000, sizeof(byte), 0x02 * 0x4000, rfile);
		port6 = fgetc(rfile);
		fclose(rfile);
	}
	if (!savfile)
		free(fname);
}


byte x5_initmem(void)
{
	FILE *rfile;
	char *fname;

	if (romfile)
		printf(">>> TI-85 (%s)\n", romfile);
	else
		puts(">>> TI-85");

	if (!(mpages = malloc((0x08 + 0x02) * 0x4000)))  {
		fprintf(stderr, "Error Allocating Memory\n");
		return(0);
	}
	lcdbuf = mpages + (0x08 * 0x4000) + 0x3C00;

	fname = romfile ? romfile : ahome("x5.rom");
	if (!(rfile = fopen(fname, "rb"))) {
		fprintf(stderr, "Rom File IO Error\n");
		free(mpages);
		return(0);
	}
	if (!romfile)
		free(fname);
	
	if (fread(mpages, sizeof(byte), 0x08 * 0x4000, rfile) != 0x08 * 0x4000) {
		fprintf(stderr, "Rom File Corrupted\n");
		free(mpages);
		return(0);
	}

	fclose(rfile);

#ifdef extlink
	ti68k_open_linkport();
#endif

	return(1);
}


void x5_cleanmem()
{
	extern byte savecode;
	FILE *rfile;
	char *fname;

#ifdef extlink
	ti68k_close_linkport();
#endif

	if (savecode) {
		fname = savfile ? savfile : ahome("x5.sav");
		if (!(rfile = fopen(fname, "wb"))) return;
		if (!savfile)
			free(fname);

		fwrite(pager, sizeof(byte), 4, rfile);
		fwrite(&R, sizeof(byte), sizeof(Z80_Regs), rfile);
		fwrite(mpages + 0x08 * 0x4000, sizeof(byte), 0x02 * 0x4000, rfile);
		fputc(port6, rfile);
		fclose(rfile);
	}

	free(mpages);
}

int x5_checkrom(char *fname)
{
	FILE *rfile;

	rfile = fopen(fname, "rb");
	if (!rfile)
		return 0;

	if (find_string("CATALOG", rfile)) {
		fclose(rfile);
		return 1;
	}

	fclose(rfile);
	return 0;
}
