/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../config.h"

#include<gtk/gtk.h>
#include<stdlib.h>
#ifndef __WIN32__
# include<unistd.h>
#endif
#include<stdio.h>

/* >>> dependencies */
#include "../main.h"
#include "../core/Z80.h"
#include "../core/dep/inter.h"
/* dependencies <<< */

#include "commands.h"
/* >>> Imported */
#include "../tools.h"
#include "screen.h"
/* Imported <<<*/


/* >>> Globals */
G_LOCK_DEFINE(ctrlspeed);
G_LOCK_DEFINE(cleanquit);
byte ctrlspeed;
byte autosave;
byte savecode;
byte iskeyb = 1;
/* Globals <<< */


/* >>> Exported */
void initstat(void)
{
	G_LOCK_EXTERN(running);
	extern struct hardware *hw;

	G_LOCK(running);
	Z80_Reset();
	Rezet(0);
	G_UNLOCK(running);
}


void revertstat(void)
{
	extern struct hardware *hw;

	Z80_Reset();
	Rezet(1);
}


void togglescr(GtkObject *screen)
{
	G_LOCK_EXTERN(running);
	G_LOCK_EXTERN(runctrl);
	extern byte lcdactive;
	extern byte lcdshow;

	guint timerid;


	resetkeyb();
	timerid = (guint) gtk_object_get_user_data(screen);
	iskeyb = 1 - iskeyb;

	gtk_timeout_remove(timerid);
	gtk_signal_disconnect_by_func(screen, GTK_SIGNAL_FUNC(exit_emulator), (gpointer) -1);
	gtk_widget_destroy(GTK_WIDGET(screen));
	create_Screen(iskeyb);

	G_LOCK(running);
	G_LOCK(runctrl);
	lcdshow = lcdactive = 1;
	G_UNLOCK(runctrl);
	G_UNLOCK(running);
}


void toggle_autosave(void)
{
	autosave = 1 - autosave;
}


void toggle_speed(void)
{
	/* G_LOCK(ctrlspeed); */
	ctrlspeed = 1 - ctrlspeed;
	/* G_UNLOCK(ctrlspeed); */
}


void exit_emulator(GtkObject *screen, gpointer data)
{
	extern struct hardware *hw;
	extern char *romfile, *savfile;
	G_LOCK_EXTERN(running);
	extern byte running;

	guint timerid;
	FILE *config;
	char *fname;

	if ((int) data != -1)
		savecode = (byte) (int) data;
	else
		savecode = autosave;

	timerid = (guint) gtk_object_get_user_data(screen);
	gtk_timeout_remove(timerid);

	G_LOCK(running);
	running = 0;
	G_UNLOCK(running);

	G_LOCK(cleanquit);

/* using savecode produces better code but will produce thread conflicts */
	/* if (data) { */
#ifdef USE_GTK_1_2
	fname = ahome("menurc");
	gtk_item_factory_dump_rc(fname, NULL, TRUE);
	free(fname);
#endif

	fname = ahome("config.dat");
	if ((config = fopen(fname, "w"))) {
		fprintf(config, magic_token);
		fprintf(config, "# you can modify this file if you're careful\n");
		fprintf(config, "model = %c\n", hw->model);
		fprintf(config, "modulespeed = %c\n", ctrlspeed?'y':'n');
		fprintf(config, "keyboard = %c\n", iskeyb?'y':'n');
		fprintf(config, "autosave = %c\n", autosave?'y':'n');
		if (romfile)
			fprintf(config, "romfile = %s\n",romfile);
		if (savfile)
			fprintf(config, "savfile = %s\n",savfile);

		fclose(config);
	}
	free(fname);
	/*}*/

	gtk_main_quit();
}
/* Exported <<< */
