/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../config.h"

#include<gtk/gtk.h>
#include<string.h>
#include<stdlib.h>
#include<stdio.h>
#include "../core/Z80.h"

#ifdef extlink
#include <ticables.h>
#include "../core/dep/link.h"
extern byte elink;		/* external link enable */
extern CableOptions elinkp;	/* link cable parameters */

static GtkWidget *el_enable, *el_type, *el_port, *el_timeout, *el_delay;

void ti68k_close_linkport();
void ti68k_open_linkport();

static void setuplink(GtkWidget *dlg)
{
	char *text;

	G_LOCK_EXTERN(running);
	G_LOCK_EXTERN(runctrl);

	G_LOCK(running);
	G_LOCK(runctrl);

	ti68k_close_linkport();

	elink = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(el_enable));

	text = gtk_combo_box_get_active_text(GTK_COMBO_BOX(el_type));
	elinkp.model = ticables_string_to_model(text);
	g_free(text);

	text = gtk_combo_box_get_active_text(GTK_COMBO_BOX(el_port));
	elinkp.port = ticables_string_to_port(text);
	g_free(text);

	text = gtk_entry_get_text(GTK_ENTRY(el_timeout));
	sscanf(text, "%u", &(elinkp.timeout));

	text = gtk_entry_get_text(GTK_ENTRY(el_delay));
	sscanf(text, "%u", &(elinkp.delay));

	ti68k_open_linkport();

	gtk_widget_destroy(dlg);

	G_UNLOCK(runctrl);
	G_UNLOCK(running);
}

static GtkWidget *packlinkcombo(GtkWidget *table, int ypos, char *name,
				GtkWidget **savelabel)
{
	GtkWidget *combo, *label;

	label = gtk_label_new(name);
		gtk_table_attach(GTK_TABLE(table), label, 0, 1, ypos, ypos+1,
				 0, 0, 2, 2);
	gtk_widget_show(label);

	combo = gtk_combo_box_new_text();
		gtk_table_attach(GTK_TABLE(table), combo, 1, 2, ypos, ypos+1,
				 GTK_EXPAND|GTK_FILL, 0, 2, 2);
	gtk_widget_show(combo);

	if (savelabel)
		*savelabel = label;

	return combo;
}

static GtkWidget *packlinkentry(GtkWidget *table, int ypos, char *name,
				const char *current, GtkWidget **savelabel)
{
	GtkWidget *entry, *label;

	label = gtk_label_new(name);
		gtk_table_attach(GTK_TABLE(table), label, 0, 1, ypos, ypos+1,
				 0, 0, 2, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(entry), current);
		gtk_table_attach(GTK_TABLE(table), entry, 1, 2, ypos, ypos+1,
				 GTK_EXPAND|GTK_FILL, 0, 2, 2);
	gtk_widget_show(entry);

	if (savelabel)
		*savelabel = label;

	return entry;
}


void changelink(void)
{
	int i, j;
	char text[256];

	GtkWidget *dlg, *table, *dialog_aa, *bbox, *button1, *button2;

	dlg = gtk_dialog_new();
		gtk_window_set_title(GTK_WINDOW(dlg), "Link Settings");
		gtk_window_set_modal(GTK_WINDOW(dlg), TRUE);

	button1 = gtk_button_new_with_label("Ok");
	gtk_widget_show(button1);

	button2 = gtk_button_new_with_label("Cancel");
	gtk_widget_show(button2);

	bbox = gtk_hbutton_box_new();
		gtk_container_add(GTK_CONTAINER(bbox), button1);
		gtk_container_add(GTK_CONTAINER(bbox), button2);
	gtk_widget_show(bbox);

	dialog_aa = GTK_DIALOG(dlg)->action_area;
		gtk_container_set_border_width(GTK_CONTAINER(dialog_aa), 10);
		gtk_box_pack_start(GTK_BOX(dialog_aa), bbox, TRUE, TRUE, 0);
	gtk_widget_show(dialog_aa);

	/* Enable */

	el_enable = gtk_check_button_new_with_label("Enable external link");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(el_enable),
					     elink);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox), el_enable,
				   TRUE, TRUE, 0);
	gtk_widget_show(el_enable);

	table = gtk_table_new(8, 2, FALSE);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox), table,
				   TRUE, TRUE, 0);
		gtk_container_set_border_width(GTK_CONTAINER(table), 2);
	gtk_widget_show(table);

	/* Cable Type */

	el_type = packlinkcombo(table, 0, "Type:", NULL);
	for (i = CABLE_GRY, j = 0; i < CABLE_ILP; i++, j++) {
		if (i != CABLE_USB) {
			gtk_combo_box_append_text(GTK_COMBO_BOX(el_type),
						  ticables_model_to_string(i));
			if (i == elinkp.model)
				gtk_combo_box_set_active(GTK_COMBO_BOX(el_type), j);
		}
		else
			j--;
	}

	/* Port */

	el_port = packlinkcombo(table, 1, "Port:", NULL);
	for (i = PORT_1; i <= PORT_4; i++) {
		gtk_combo_box_append_text(GTK_COMBO_BOX(el_port),
					  ticables_port_to_string(i));
		if (i == elinkp.port)
			gtk_combo_box_set_active(GTK_COMBO_BOX(el_port),
						 i - PORT_1);
	}

	/* Timeout */

	sprintf(text,"%d",elinkp.timeout);
	el_timeout = packlinkentry(table, 2, "Timeout:", text, NULL);

	/* Delay */

	sprintf(text,"%d",elinkp.delay);
	el_delay = packlinkentry(table, 3, "Delay:", text, NULL);

	gtk_signal_connect_object(GTK_OBJECT(button1), "clicked",
				  GTK_SIGNAL_FUNC(setuplink), GTK_OBJECT(dlg));
	gtk_signal_connect_object(GTK_OBJECT(button2), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(dlg));

	gtk_widget_show(dlg);
}

#else

void changelink(void)
{

}

#endif

