/* Tilem neosign - Converts binary files to the .hex app format
 * Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include<stdio.h>
#include<stdlib.h>

int main (int argc, char *argv[])
{
	FILE *bin, *app;
	char i, *page;
	int l;

	puts("Tilem NeoSign v0.9 Beta - (C) 2000 Solignac Julien");
	puts("THIS PROGRAM COMES WITH ABSOLUTLY NO WARRANTY");
	puts("PLEASE READ THE DOCUMENTATION FOR DETAILS");
	if (argc != 2) {
		puts("Usage: neosign file");
		exit(0);
	}

	if ((!(bin = fopen(argv[1], "r"))) || (!(app = fopen("hex.app", "w")))) {
		fprintf(stderr, "File IO Error\n");
		exit(-1);
	}

	if (!(page = malloc(0x4000))) {
		fprintf(stderr, "Insufficient Memory\n");
		exit(-1);
	}

	printf("'Signing' App... ");
	fflush(stdout);

	fprintf(app, ":XXXXXXXX____XX\n");
	for (l = 0; l < 0x4000 / 0x20; l++) {
		fprintf(app, ":XXXXXXXX");
		for (i = 0; i < 32; i++)
			fprintf(app,"%02X", 0xFF & fgetc(bin));

		fprintf(app, "XX\n");
	}
	fprintf(app, ":XXXXXXXX__");

	puts("Done");

	fclose(bin);
	fclose(app);

	return(0);
}
