/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include<stdio.h>
#include<string.h>
#include<signal.h>
#include<sys/types.h>

/* >>> Imported */
#include "Z80.h"

void resetkeyb(void);
/* Imported <<< */


/* >>> Global */
G_LOCK_DEFINE(halted);
int halted = 0;
/* Global <<< */


/* >>> Resources */
/* static pid_t jcdebug; */
/* Resources <<< */

/* >>> Exported */
void Z80_Debug()
{
	G_LOCK_EXTERN(traps);
	extern int trap_want_db;

	resetkeyb();
	/* kill(jcdebug, SIGUSR1); */

	/* G_LOCK(halted); */
	/* G_LOCK(halted); */
	/* G_UNLOCK(halted); */

	G_LOCK(halted);
	G_LOCK(traps);
	trap_want_db = 1;
	halted = 1;
	G_UNLOCK(traps);

	while(halted) {
		G_UNLOCK(halted);
		g_usleep(1000);
		G_LOCK(halted);
	}
	G_UNLOCK(halted);
}
/* Exported <<< */
