/* DBUS status bits */

/* Disabled, must be set on all calcs that don't support it!
   Can be controlled by port 8 on calcs that do support it */
#define DBUS_DISABLED 0x80

/* Following bits are reported through the DBUS status port (port 9) */

/* Error, set in the case of a collision */
#define DBUS_ERROR 0x40

/* Ready, set if no data is being sent or received */
#define DBUS_READY 0x20

/* Data, set if data has been received */
#define DBUS_DATA 0x10

/* Overflow, set if data has been received and we're waiting to send more */
#define DBUS_OVERFLOW 0x08

/* This bit is for internal use only, it is never reported to the calc */
/* Write, set if calc is waiting to send data */
#define DBUS_WRITE 0x04
