/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../../config.h"

#include<stdlib.h>
#include<stdio.h>
#include<glib.h>

/* >>> dependencies */
#include "../Z80.h"
/* dependencies <<< */


#include "inter.h"
/* >>> Imported */
extern struct wbplist bpdat[maxbp];
extern word Z80_Trace, stepbpx;
extern struct hardware *hw;
/*extern char statmess[40];*/
extern byte numbp;
/* Imported <<< */


/* >>> Concat */
#include "shared.c"
#include "rom.c"
/* Concat <<< */


/* >>> Exported */
void resetkeyb(void) {
	byte i;

	for (i = 0; i < 7; i++)
		scode[i] = 0xFF;
}


void trace_Z80_Out(byte Port, byte Value)
{
	byte i;
	extern byte writemem;

	writemem = 1;
	
	for (i = 0; i < (stepbpx?0:numbp); i++)
		if ((bpdat[i].type & BPTYPE_PW) && ((Port >= bpdat[i].addr_from) && (Port <= bpdat[i].addr_to))) {
			Z80_Trace = 1;
			/* snprintf(statmess, 40, "IO Write Breakpoint at Port 0x%02hhX", Port); */
		}

	(hw->xZ80_Out)(Port, Value);
}


byte trace_Z80_In(byte Port)
{
	byte i;

	for (i = 0; i < (stepbpx?0:numbp); i++)
		if ((bpdat[i].type & BPTYPE_PR) && ((Port >= bpdat[i].addr_from) && (Port <= bpdat[i].addr_to))) {
			Z80_Trace = 1;
			/* snprintf(statmess, 40, "IO Read Breakpoint at Port 0x%02hhX", Port); */
		}

	return((hw->xZ80_In)(Port));
}


void trace_Z80_WRMEM(dword A, byte v)
{
	byte i;
	extern byte writemem;

	writemem = 1;

	for (i = 0; i < (stepbpx?0:numbp); i++)
		if ((bpdat[i].type & BPTYPE_W) && ((A >= bpdat[i].addr_from) && (A <= bpdat[i].addr_to))) {
			Z80_Trace = 1;
			/* snprintf(statmess, 40, "Memory Write Breakpoint at 0x%04X", A); */
		}

	(hw->xZ80_WRMEM)(A, v);
}


unsigned trace_Z80_RDMEM(dword A)
{
	byte i;

	A &= 0xFFFF;
	for (i = 0; i < (stepbpx?0:numbp); i++)
		if ((bpdat[i].type & BPTYPE_R) && ((A >= bpdat[i].addr_from) && (A <= bpdat[i].addr_to))) {
			Z80_Trace = 1;
			/* snprintf(statmess, 40, "Memory Read Breakpoint at 0x%04X", A); */
		}

	return((hw->xZ80_RDMEM)(A));
}
/* Exported <<< */
