#ifndef _inter

#define _inter

#include "../Z80.h"

/****************************************************************************/
/* Factorized breakpoint traps                                              */
/****************************************************************************/
void trace_Z80_WRMEM(dword A, byte v);
unsigned trace_Z80_RDMEM(dword A);

void trace_Z80_Out(byte Port, byte Value);
byte trace_Z80_In(byte Port);

/****************************************************************************/
/* Keyboard data                                                            */
/****************************************************************************/
void resetkeyb(void);
extern byte scode[7];

/****************************************************************************/
/* Read a byte from given memory location without debugging                 */
/****************************************************************************/
unsigned Z80_RDOP(dword A);

/****************************************************************************/
/* Read a byte from given memory location                                   */
/****************************************************************************/
unsigned Z80_RDMEM(dword A);

/****************************************************************************/
/* Write a byte to given memory location                                    */
/****************************************************************************/
void Z80_WRMEM(dword A, byte V);

/****************************************************************************/
/* Input a byte from given I/O port                                         */
/****************************************************************************/
byte Z80_In(byte Port);

/****************************************************************************/
/* Output a byte to given I/O port                                          */
/****************************************************************************/
void Z80_Out(byte Port, byte Value);

/****************************************************************************/
/* Handle keyboard signals                                                  */
/****************************************************************************/
void emkeyin(unsigned short keyv, byte i);
void emkeyup(unsigned short keyv, byte i);

/****************************************************************************/
/* Reset Calc                                                               */
/****************************************************************************/
void Rezet(byte i);

/****************************************************************************/
/* Allocate/Free necessary memory                                           */
/****************************************************************************/
byte initmem(void);
void cleanmem(void);

int find_string(char *, FILE *);

#define Z80_RDOP(A)	(hw->xZ80_RDMEM)(A)
#define Z80_RDMEM(A)	(trace_Z80_RDMEM)(A)
#define Z80_WRMEM(A,v)	(trace_Z80_WRMEM)(A, v)
#define Z80_In(v)	(trace_Z80_In)(v)
#define Z80_Out(p,v)	(trace_Z80_Out)(p, v)
#define emkeyin(v,i)	(hw->xemkeyin)(v,i)
#define emkeyup(v,i)	(hw->xemkeyup)(v,i)
#define Rezet(i)	(hw->xRezet)(i)
#define initmem()	(hw->xinitmem)()
#define cleanmem()	(hw->xcleanmem)()

struct kmapsto {
	word	xmin, xmax, ymin, ymax;

	byte	menu_top;
	byte	menu_bas;

	byte	margin_left;
	word	margin_top;

	byte	rmod_horiz;
	byte	rmod_vert;
	byte	rx_void;
	byte	ry_void;
	
	word	ar_boxleft;
	word	ar_boxright;
	word	ar_boxtop;
	word	ar_boxbas;

	word	ar_lrmin;
	word	ar_lrmax;
	word	ar_tdmin;
	word	ar_tdmax;

	word	ar_left;
	word	ar_right;
	word	ar_top;
	word	ar_down;
};

extern struct kmapsto x3pmap;
extern struct kmapsto x2map;
extern struct kmapsto x4maps[];


struct hardware {
	char		model;
	byte		magic;
	byte		xpix /*, ypix*/;
	int		nkeyb;
	struct kmapsto	*keyb;
	unsigned long	romsize, ramsize;

	byte		(*xinitmem)	(void);
	void		(*xcleanmem)	(void);
	void		(*xRezet)	(byte);
	byte		(*xZ80_In)	(byte);
	void		(*xZ80_Out) 	(byte, byte);
	void		(*xZ80_WRMEM)	(dword, byte);
	unsigned	(*xZ80_RDMEM)	(dword);
	int		(*xemkeyin)	(guint, byte);
	int		(*xemkeyup)	(guint, byte);
	void		(*xloadapp)	(char *);
	int		(*xcheckrom)	(char *);
};

#endif
