#include <string.h>

/* Search for a string within the ROM file */

int find_string(char *s, FILE *f)
{
	char buf[256];
	int pos = 0;
	int len, i;

	len = strlen(s);

	for (i = 0; i < len-1; i++) {
		buf[pos] = fgetc(f);
		pos = (pos+1)%256;
	}

	while (!feof(f) && !ferror(f)) {
		buf[pos] = fgetc(f);
		pos = (pos+1)%256;

		for (i = 0; i < len; i++) {
			if ((s[i] != buf[(pos - len + i)%256]) &&
			    (s[i] != (buf[(pos - len + i)%256] ^ 0x20)))
				break;
		}
		if (i == len)
			return 1;
	}
	return 0;
}
