/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* >>> Imported */
#include "../../../tools.h"
/* Imported <<< */

extern char *romfile;
extern char *savfile;

#ifdef extlink
void ti68k_close_linkport();
void ti68k_open_linkport();
#endif


void x2_Rezet(byte i)
{
	extern Z80_Regs R;
	extern byte lcdshow;
	extern byte lcdactive;

	FILE *rfile;
	char *fname;


	lcdmode = xlcd = ylcd = 0;
	lcdinc = 4;
	port2 = 0xF8;
	port4 = 100000;
	onkey = 0;
	tilnk = 0;
	pclnk = 0x03;
	dbusstat = DBUS_DISABLED;
	lpmode = 0; /* autodetect linkport mode */

	pager[0] = 0x00;
	pager[1] = 0x00;
	pager[2] = 0x08; 
	pager[3] = 0x09;

	memset(mpages + 0x08 * 0x4000, 0x00, 0x02 * 0x4000);
	if (i == 0) return;

	fname = savfile ? savfile : ahome("x2.sav");
	if ((rfile = fopen(fname, "rb"))) {
		lcdshow = lcdactive = 1;
		fread(pager, sizeof(byte), 4, rfile);
		fread(&R, sizeof(Z80_Regs), 1, rfile);
		fread(&port4, sizeof(port4), 1, rfile);
		fread(&port2, sizeof(port2), 1, rfile);
		fread(mpages + 0x08 * 0x4000, sizeof(byte), 0x02 * 0x4000 + 0x300, rfile);
		lcdmode = fgetc(rfile);
		xlcd = fgetc(rfile);
		ylcd = fgetc(rfile);
		fclose(rfile);
	}
	if (!savfile)
		free(fname);
}


byte x2_initmem(void)
{
	FILE *rfile;
	char *fname;

	if (romfile)
		printf(">>> TI-82 (%s)\n", romfile);
	else
		puts(">>> TI-82");

	if (!(mpages = malloc((0x08 + 2) * 0x4000 + 0x300)))  {
		fprintf(stderr, "Error Allocating Memory\n");
		return(0);
	}

	lcdbuf = mpages + (0x08 + 2) * 0x4000;
	memset(lcdbuf, 0xFF, 0x300);

	fname = romfile ? romfile : ahome("x2.rom");
	if (!(rfile = fopen(fname, "rb"))) {
		fprintf(stderr, "Rom File IO Error\n");
		free(mpages);
		return(0);
	}
	if (!romfile)
		free(fname);
	
	if (fread(mpages, sizeof(byte), 0x08 * 0x4000, rfile) != 0x08 * 0x4000) {
		fprintf(stderr, "Rom File Corrupted\n");
		free(mpages);
		return(0);
	}

	fclose(rfile);

#ifdef extlink
	ti68k_open_linkport();
#endif

	return(1);
}


void x2_cleanmem()
{
	extern byte savecode;
	FILE *rfile;
	char *fname;

#ifdef extlink
	ti68k_close_linkport();
#endif

	if (savecode) {
		fname = savfile ? savfile : ahome("x2.sav");
		if ((rfile = fopen(fname, "wb"))) {
			fwrite(pager, sizeof(byte), 4, rfile);
			fwrite(&R, sizeof(Z80_Regs), 1, rfile);
			fwrite(&port4, sizeof(port4), 1, rfile);
			fwrite(&port2, sizeof(port2), 1, rfile);
			fwrite(mpages + 0x08 * 0x4000, sizeof(byte), 0x02 * 0x4000 + 0x300, rfile);
			fputc(lcdmode, rfile);
			fputc(xlcd, rfile);
			fputc(ylcd, rfile);
			fclose(rfile);
		}
		if (!savfile)
			free(fname);
	}

	free(mpages);
}

int x2_checkrom(char *fname)
{
	FILE *rfile;

	rfile = fopen(fname, "rb");
	if (!rfile)
		return 0;

	if (find_string("CATALOG", rfile)) {
		fclose(rfile);
		return 0;
	}

	fclose(rfile);
	return 1;
}
