/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


void handlelink(byte line);

byte x3_Z80_In(byte Port)
{
	byte v, i;
	
	switch(Port) {
		case 0x00:
			handlelink((~tilnk & pclnk) & 0x03);
			return(((pager[1] & 0x08) << 1) | (((~tilnk & pclnk) & 0x03) << 0x02));

		case 0x01:
			updatekb();

			v = 0xFF;
			for (i = 0; i < 7; i++)
				v &= ((keymask >> i) & 0x01)?0xFF:scode[i];

			return(v);

		case 0x02:
			return(port2);

		case 0x03:
			/* if (R.IFF1) puts("** unexpected: port 3 read with FF **"); */

			if (port4) {
				port4--;
				return(0x01);
			}

			if (onkey) {
				onkey--;
				return(0x01);
			}

			return(0x08|(R.IFF1?0:2));

		case 0x06:
			return(pager[1]);

		case 0x07:
			return(0x40 | (pager[2] == 0x21));

		case 0x11:
			return(LCDIn());

		case 0x14:
			return(0x01);

	}
	printf("** Experimental ** inimplemented port read: %d\n", Port);
	return(0x00);
}


void x3_Z80_Out(byte Port, byte Value)
{
	extern byte lcdshow;

	switch(Port) {
		case 0x00:
			pager[1] = (pager[1] & 0x07) | ((Value & 0x10) >> 1);
			tilnk = Value & 0x03;
			handlelink((~tilnk & pclnk) & 0x03);
			break;

		case 0x01:
			keymask = Value;
			break;

		case 0x02:
			port2 = Value;
			pager[1] = (pager[1] & 0x08) | (Value & 0x07);
			break;

		case 0x04:
			break;
	
		case 0x06:
			puts("6");
			break;

		case 0x10:
			LCDDriver(Value);
			break;

		case 0x11:
			lcdshow = 1;
			LCDOut(Value);
	}

	return;
}


/* void x3_emkeyin(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */
/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i == 40) { */
/* 		onkey = 4150; */
/* 		return; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] &= ~(1 << (i & 0x07)); */

/* 	return; */
/* } */


/* void x3_emkeyup(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */
/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] |= 1 << (i & 0x07); */

/* 	return; */
/* } */
