/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


void handlelink(byte line);


byte x5_Z80_In(byte Port)
{
	byte v, i;
	
	switch(Port) {
		case 0x01:
			updatekb();

			v = 0xFF;
			for (i = 0; i < 7; i++)
				v &= ((keymask >> i) & 0x01)?0xFF:scode[i];
			return(v);

		case 0x03:
			if (port3) {
				port3--;
				return(1);
			}

			if (onkey) {
				onkey--;
				return(1);
			}

			return(0x08 | (R.IFF1?0:2));

		case 0x04:
			return(0x01);

		case 0x05:
			return(pager[1]);

		case 0x06:
			return(port6);

		case 0x07:
			handlelink(~tilnk & pclnk);
			return(0xc0 | (tilnk << 2) | (~tilnk & pclnk));
			/* return(0x03); */
	}
	printf("** Experimental ** inimplemented port read: %d\n", Port);
	return(0x00);
}


void x5_Z80_Out(byte Port, byte Value)
{
	extern byte lcdactive;
  	extern byte lcdshow;

	switch(Port) {
		case 0x00:
			lcdbuf = (mpages + 0x08 * 0x4000) + ((Value & 0x3F) << 8);
			break;

		case 0x01:
			keymask = Value;
			break;

		case 0x02:
			/* Contrast */
			break;

		case 0x03:
			/* Interrupts / LCD power */
			lcdactive = Value & 0x08;
			if (lcdactive)
				lcdshow = 1;

			break;

		case 0x04:
			/* LCD control */
			break;

		case 0x05:
			pager[1] = Value & 0x07;
			break;

		case 0x06:
			/* Power */
			port6 = Value;
			break;

		case 0x07:
			/* Link */
			tilnk = ((Value>>4) & (Value>>2) & 0x03);

			handlelink((~tilnk & pclnk) & 0x03);
			break;
	}

	return;
}

