/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


void handlelink(byte line);


byte x6_Z80_In(byte Port)
{
	byte v, i;
	
	switch(Port) {
		case 0x01:
			updatekb();

			v = 0xFF;
			for (i = 0; i < 7; i++)
				v &= ((keymask >> i) & 0x01)?0xFF:scode[i];
			return(v);

		case 0x03:
			if (port3) {
				port3--;
				return(0x01);
			}


			if (onkey) {
				onkey--;
				return(0x01);
			}

			return(0x08 | (R.IFF1?0:2));

		case 0x04:
			return(0x01);

		case 0x05:
			return(((pager[1] << 2) & 0x40) | (pager[1] & 0x0F));

		case 0x06:
			return(((pager[2] << 2) & 0x40) | (pager[2] & 0x0F));

		case 0x07:
			handlelink(~tilnk & pclnk);
			return((~tilnk & pclnk) | (tilnk << 0x02));
			/* return(0x03); */
	}
	printf("** Experimental ** inimplemented port read: %d\n", Port);
	return(0x00);
}


void x6_Z80_Out(byte Port, byte Value)
{
	extern byte lcdactive;
  	extern byte lcdshow;

	switch(Port) {
		case 0x00:
			lcdbuf = (mpages + 0x10 * 0x4000) + ((Value & 0x3F) << 8);
/* default = 3C -> 0xfc00 */			
			break;

		case 0x01:
			keymask = Value;
			break;

		case 0x02:
/* CONTAST */
			break;

		case 0x03:
/* Lcd Power */
			lcdactive = Value & 0x08;
			if (lcdactive)
				lcdshow = 1;

			break;
	
		case 0x04:
/* Power */
			break;

		case 0x05:
			pager[1] = ((Value >> 2) & 0x10) + (Value & 0x0F);
			break;

		case 0x06:
			pager[2] = ((Value >> 2) & 0x10) + (Value & 0x0F);
			break;

		case 0x07:
			if ((Value == 0x7C) && (lnkinit)) {
				lnkinit = 0;
				break;
			}
				tilnk = (Value >> 0x02) & 0x03;
			handlelink(~tilnk & pclnk);
/* Link */
			break;
	}

	return;
}

/* /\* these haven't been checked ! *\/ */
/* void x6_emkeyin(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */
/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i == 40) { */
/* 		onkey = 4150; */
/* 		return; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] &= ~(1 << (i & 0x07)); */

/* 	return; */
/* } */


/* void x6_emkeyup(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */
/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] |= 1 << (i & 0x07); */

/* 	return; */
/* } */
