/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

void timer_set_mode(byte port, byte value)
{
	timermode[(port-0x30)/3] = value;
}

void timer_set_loop(byte port, byte value)
{
	timerloop[(port-0x31)/3] = value;

	if (value & 1)
		printf("**programmable timer interrupts not supported**\n");
}

void timer_set_value(byte port, byte value)
{
	if (timermode[(port-0x32)/3] & 0x80) {
		
	}
	else if (timermode[(port-0x32)/3] & 0x40) {

	}
	else {
		timeroffs[(port-0x32)/3] = value;
	}
}

byte timer_get_value(byte port)
{

}
