/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

struct sect {long start, size; byte s;};

struct sect xz_sectors[]={{0x000000, 0x10000, 1},
			  {0x010000, 0x10000, 1},
			  {0x020000, 0x10000, 1},
			  {0x030000, 0x10000, 1},
			  {0x040000, 0x10000, 1},
			  {0x050000, 0x10000, 1},
			  {0x060000, 0x10000, 1},
			  {0x070000, 0x10000, 1},
			  {0x080000, 0x10000, 1},
			  {0x090000, 0x10000, 1},
			  {0x0A0000, 0x10000, 1},
			  {0x0B0000, 0x10000, 1},
			  {0x0C0000, 0x10000, 1},
			  {0x0D0000, 0x10000, 1},
			  {0x0E0000, 0x10000, 1},
			  {0x0F0000, 0x10000, 1},
			  {0x100000, 0x10000, 1},
			  {0x110000, 0x10000, 1},
			  {0x120000, 0x10000, 1},
			  {0x130000, 0x10000, 1},
			  {0x140000, 0x10000, 1},
			  {0x150000, 0x10000, 1},
			  {0x160000, 0x10000, 1},
			  {0x170000, 0x10000, 1},
			  {0x180000, 0x10000, 1},
			  {0x190000, 0x10000, 1},
			  {0x1A0000, 0x10000, 1},
			  {0x1B0000, 0x10000, 3},
			  {0x1C0000, 0x10000, 1},
			  {0x1D0000, 0x10000, 1},
			  {0x1E0000, 0x10000, 1},
			  {0x1F0000, 0x08000, 1},
			  {0x1F8000, 0x02000, 1},
			  {0x1FA000, 0x02000, 1},
			  {0x1FC000, 0x04000, 3},
			  {0, 0, 0}};

void xp_flash_write(byte *mem, unsigned long pa, byte v, byte lastpage,
		    struct sect* secs);


void xz_Z80_WRMEM(dword A, byte v)
{
  unsigned long pa;
  byte page;

  A &= 0xFFFF;
  page = pager[A>>14];

  if (A & 0x8000) {
    if (A > (0xFFFF - 64 * port27))
      page = 0x80;
    else if (A < (0x8000 + 64 * port28))
      page = 0x81;
  }

  pa = (A & 0x3FFF) + 0x4000L*page;

  if (pa<0x200000) {
    xp_flash_write(mpages,pa,v,0x7F,xz_sectors);
  }

  else if (pa < 0x220000)
    *(mpages+pa) = v;
}


unsigned xz_Z80_RDMEM(dword A)
{
  extern Z80_Regs R;
  byte page;
  static byte warned=0;

  A &= 0xFFFF;
  page = pager[A>>14];

  if (A & 0x8000) {
    if (A > (0xFFFF - 64 * port27))
      page = 0x80;
    else if (A < (0x8000 + 64 * port28))
      page = 0x81;
  }

  if (A==R.PC.W.l) {
    if ((page&0x81)==0x80) {
      if (!warned) {
	printf("** executing in restricted RAM area **\n");
	warned = 1;
      }
    }
    else if ((page >= port22) && (page <= port23)) {
      if (!warned) {
	printf("** executing in restricted Flash area **\n");
	warned = 1;
      }
    }
    else
      warned = 0;
  }

  if (page == 0x7E) {
    if (flashlock) {
      /* Bitmask for apps, starting with bit 1, 0 = Enabled, 1 = Disabled ;) */
      /* if ((A & 0x1FFF) == 0x1FE0 || (A & 0x1FFF) == 0x1FE1)
	 return(0x00); */
    }
    else {
      printf("** reading from read-protected sector **\n");
      return 0xff;
    }
  }

  return(*(mpages + 0x4000 * page + (A & 0x3FFF)));
}
