/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../config.h"

#include<gtk/gtk.h>
#include<stdlib.h>
#include<string.h>
#include<stdio.h>


/* >>> dependencies */
#include "../core/Z80.h"
#include "../core/dep/inter.h"
/* dependencies <<< */

#include "files.h"
/* >>> Imported */
#include "changehw.h"
#include "../io.h"
/* Imported <<< */


/* >>> Resources */
static char* lastfile = NULL;

static byte* savedata;
static byte* saveprgmname;

G_LOCK_DEFINE(save);
/* Resources <<< */

/* >>> Static */
static void savedestroy(GtkWidget *filewin)
{
	G_LOCK(save);
	savedata = saveprgmname = NULL;
	G_UNLOCK(save);

	gtk_widget_destroy(GTK_WIDGET(filewin));
}


static void savefile(GtkWidget *filewin)
{
	byte *name, *data;

	name = (byte *)	gtk_object_get_data(GTK_OBJECT(filewin), "name");
	data = (byte *)	gtk_object_get_data(GTK_OBJECT(filewin), "data");

	dumpfile(getfilename(filewin), name, data);
	savedestroy(filewin);
}


static void loadfile(GtkWidget *filewin)
{
	char *file;

	file = getfilename(filewin);
	upload(file);

	gtk_widget_destroy(GTK_WIDGET(filewin));
}

static void loadromfile(GtkWidget *filewin)
{
	char *file;
	gpointer data;

	file = getfilename(filewin);
	data = gtk_object_get_user_data(GTK_OBJECT(filewin));
	add_rom(file, data);

	gtk_widget_destroy(GTK_WIDGET(filewin));
}
/* Static <<< */


/* >>> Exported */
void setfilename(GtkWidget *filew)
{
	extern struct hardware *hw;

	if (!(lastfile)) {
		lastfile = strdup("TilEm.8?p");
		if (hw->model == 'p' || hw->model == 's' || hw->model == '4')
			*(lastfile + 7) = 'x';
		else if (hw->model == '7')
			strcpy(lastfile+6,"73p");
		else
			*(lastfile + 7) = hw->model;
	}
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew), lastfile);
}


char *getfilename(GtkWidget *widget)
{
	if (lastfile)
		free(lastfile);
	lastfile = strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(widget)));
	return(lastfile);
}


GtkWidget *create_filedlg(const char *title, int save, filewinfunc cancelfunc,
			  filewinfunc okfunc)
{
	GtkWidget *w;
	w = gtk_file_selection_new(title);
		gtk_window_set_modal(GTK_WINDOW(w), TRUE);
		gtk_signal_connect(GTK_OBJECT(w), "destroy", cancelfunc, w);
		gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(w)->cancel_button), "clicked", cancelfunc, GTK_OBJECT(w));
		gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(w)->ok_button), "clicked", okfunc, GTK_OBJECT(w));
	return w;
}


void create_savedlg(byte *data, byte *prgmname)
{
	G_LOCK_EXTERN(traps);
	extern int trap_want_save;

	G_LOCK(save);
	while (savedata || saveprgmname) {
		G_UNLOCK(save);
		g_usleep(1);
		G_LOCK(save);
	}
	savedata = data;
	saveprgmname = prgmname;
	G_UNLOCK(save);

	G_LOCK(traps);
	trap_want_save=1;
	G_UNLOCK(traps);
}

void trap_save()
{
	GtkWidget *filew;
	filew = create_filedlg("Save file as", 1,
			       (filewinfunc) savedestroy,
			       (filewinfunc) savefile);

	G_LOCK(save);
	gtk_object_set_data(GTK_OBJECT(filew), "data", (gpointer) savedata);
	gtk_object_set_data(GTK_OBJECT(filew), "name", (gpointer) saveprgmname);
	G_UNLOCK(save);

	setfilename(filew);
	gtk_widget_show(filew);
}

void create_loaddlg(void)
{
	GtkWidget *filew;

	filew = create_filedlg("Load file or App", 0,
			       (filewinfunc) gtk_widget_destroy,
			       (filewinfunc) loadfile);
	setfilename(filew);
	gtk_widget_show(filew);
}

void create_romdlg(GtkWidget *w)
{
	GtkWidget *filew;

	filew = create_filedlg("Load ROM file", 0,
			       (filewinfunc) gtk_widget_destroy,
			       (filewinfunc) loadromfile);
	gtk_object_set_user_data(GTK_OBJECT(filew), (gpointer) w);

	gtk_widget_show(filew);
}
/* Exported <<< */
