/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../config.h"

#include<gtk/gtk.h>
#include<stdlib.h>
#include<stdio.h>

#ifdef USE_GTK_1_2
#include<gdk_imlib.h>
#endif

/* >>> Imported */
#include "../tools.h"
/* Imported <<< */


/* >>> Exported */
void create_pixmap(char *filename, GtkWidget *parent, GdkPixmap **pixmap, GdkBitmap **mask)
{
	char *fname;

	fname = ashare(filename);
	*pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, gtk_widget_get_colormap(GTK_WIDGET(parent)), mask, NULL, fname);
	free(fname);

	if (!(*pixmap))
		g_error("unable to pixmap '%s'\n", filename);
}


GtkWidget *load_image(char *filename)
{
	GtkWidget *pixmap;
	char *fname;

#ifdef USE_GTK_1_2
	GdkPixmap *pix;
	GdkBitmap *msk;
	GdkImlibImage *im;
	gint w,h;

	fname = ashare(filename);
	im = gdk_imlib_load_image(fname);
	free(fname);

	w = im->rgb_width;
	h = im->rgb_height;
	gdk_imlib_render(im, w, h);
	pix = gdk_imlib_move_image(im);
	msk = gdk_imlib_move_mask(im);

	pixmap = gtk_pixmap_new(pix, msk);
	gdk_imlib_free_pixmap(pix);
#else
	fname = ashare(filename);
	pixmap = gtk_image_new_from_file(fname);
	free(fname);
#endif
	return(pixmap);
}
/* Exported <<< */
