/*  Tilem, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../config.h"

#include<stdlib.h>
#include<string.h>
#include<stdio.h>
#include<glib.h>

#include "symbols.h"

/* >>> dependencies */
#include "core/dep/inter.h"
/* dependencies <<< */


/* >>> Imported */
#include "tools.h"
/* Imported <<<*/


/* >>> Global */
struct symboldat* symbols = NULL;
word numsymbols;
/* Global <<< */


/* >>> Static */
static int symcmp(const void *sym1, const void *sym2)
{
	return(((struct symboldat*) sym1)->address - ((struct symboldat*) sym2)->address);
}


static void clearlst(void)
{
	extern unsigned short lstpc[12];

	lstpc[0] = lstpc[1] = 0xFFFF;
}
/* Static <<< */


/* >>> Exported */
void clearsymbols(void)
{
	unsigned short i;

	if (!(symbols)) return;

	for (i = 0; i < numsymbols; i++)
		free(symbols[i].label);

	loadstdsym();
}


void loadstdsym(void)
{
	extern struct hardware *hw;

	char fline[100], sname[100];
	word sloc, xc = 0;
	FILE *z80syms;
	char *fname;
	char m;

	if (symbols) {
		free(symbols);
		symbols = NULL;
	}

	
	if (hw->model == 's' || hw->model == '4' || hw->model == 'z')
	  m = 'p';
	else
	  m = hw->model;

	snprintf(sname, 100,
		 ".." G_DIR_SEPARATOR_S "data" G_DIR_SEPARATOR_S "x%csyms", m);
	fname = ashare(sname);
	z80syms = fopen(fname, "r");
	free(fname);

	if (!(z80syms)) {
		fprintf(stderr, "error accessing standard symbols\n");
		return;
	}

	do {
		xc++; 
	} while (fgets(fline, 100, z80syms));
	xc--;

	numsymbols = xc;
	if ((symbols = calloc(xc, sizeof(struct symboldat)))) {
		xc = 0;
		rewind(z80syms);
		while ((fgets(fline, 100, z80syms))) {
			sscanf(fline, "%s %04hx ", sname, &sloc);
			symbols[xc].label = strdup(sname);
			symbols[xc].address = sloc;
			xc++;
		}
	}
	fclose(z80syms);
	qsort(symbols, numsymbols, sizeof(struct symboldat), symcmp);

	clearlst();
}


void loadsyms(char *fname)
{
	char fline[100], slab[100];
	word sloc, xc = 0;
	FILE *z80syms;

	if (!(z80syms = fopen(fname, "r"))) {
		fprintf(stderr, "Error opening symbol file: %s\n", fname);
		return;
	}

	do {
		xc++;
	} while (fgets(fline, 100, z80syms));
	xc--;

	if (!(symbols = realloc(symbols, (numsymbols + xc) * sizeof(struct symboldat)))) {
		fprintf(stderr, "Insufficient Memory\n");
		fclose(z80syms);
		return;
	}

	rewind(z80syms);

	/* numsymbols += xc;
	   xc = numsymbols - xc; */
	while ((fgets(fline, 100, z80syms))) {
		if (!(strchr(fline, '='))) {
			if (2 == sscanf(fline,"%s%hx",slab,&sloc)) {
				symbols[numsymbols].label = strdup(slab);
				symbols[numsymbols].address = sloc;
				numsymbols++;
			}
		}
		else {
			if (2 == sscanf(fline, "%s = %hx, L.*", slab, &sloc)) {
				symbols[numsymbols].label = strdup(slab);
				symbols[numsymbols].address = sloc;
				numsymbols++;
			}
		}
	}

	qsort(symbols, numsymbols, sizeof(struct symboldat), symcmp);
	fclose(z80syms);

	clearlst();
}


byte translate(word tword, char **assign)
{
	struct symboldat tempsym, *matchingsym;

	if (symbols) {
		tempsym.address = tword;
		matchingsym = (struct symboldat *) bsearch((void *) &tempsym, (void *) symbols, numsymbols, sizeof(struct symboldat), symcmp);

		if (matchingsym) {
			*assign = matchingsym->label;
			return(1);
		}
	}
	return(0);
}
/* Exported <<< */
