/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../../../config.h"

#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<glib.h>

#include "internal.c"
#include "../inter.h"
#include "../dbus.h"
#include "../../../keypad.h"

#include "init.c"
#include "memory.c"
#include "io.c"


struct kmapsto x6map = {
	0,400,0,700,

	207, 224,
	28, 262,
	52, 37, 43, 25,

	186, 289, 242, 325,

	258, 300,
	211, 264,

	215, 259,
	269, 298
};

struct hardware x6 = {'6', 0x06, 0x80,
		      1, &x6map,
		      0x10 * 0x4000, 0x08 * 0x4000,
		      x6_initmem, x6_cleanmem, x6_Rezet,
		      x6_Z80_In, x6_Z80_Out,
		      x6_Z80_WRMEM, x6_Z80_RDMEM,
		      xkeyin, xkeyup,
		      NULL,
		      x6_checkrom};
