/*  TilEm, TI-Linux Emulator
 *  Copyright (C) 2001 Solignac Julien <x1cygnus@xcalc.org>
 *  Portions copyright (C) 2004 Benjamin Moody <benjamin@ecg.mit.edu>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

extern byte lcdactive, lcdmode, lcdinc;

void handlelink(byte line);

int x7_protectport(byte portaddr);

byte x7_Z80_In(byte Port)
{
	byte v, i;
	
	switch(Port&0x1f) {
		case 0x00:
			handlelink((~tilnk & pclnk) & 0x03);
			return((~tilnk & pclnk) & 0x03);

		case 0x01:
			updatekb();

			v = 0xFF;
			for (i = 0; i < 7; i++)
				v &= ((keymask >> i) & 0x01)?0xFF:scode[i];

			return(v);

		case 0x02:
			return(0x05);

		case 0x03:
			return(0x0b);

		case 0x04:
/*			if (R.IFF1) puts("** unexpected: port 4 read with FF **");*/

			if (port4) {
				port4--;
				return(0x01);
			}

			if (onkey) {
				onkey--;
				return(0x01);
			}

			return(0x0A);

		case 0x06:
			return(pager[1+memmode]&0x1f)|((pager[1+memmode]&0x20)<<1);

		case 0x07:
			return(pager[2+memmode]&0x1f)|((pager[2+memmode]&0x20)<<1);

		case 0x10:
		  	return(0x40 | lcdmode << 6| lcdactive << 5 | (lcdinc & 3));

		case 0x11:
			return(LCDIn());

	}
	printf("** unexpected ** %d\n", Port);
	return(0x00);
}


void x7_Z80_Out(byte Port, byte Value)
{
	extern byte lcdshow;

	switch(Port) {
		case 0x00:
			tilnk = Value;
			handlelink((~tilnk & pclnk) & 0x03);
			break;

		case 0x01:
			keymask = Value;
			break;

		case 0x04:
		  	if (memmode != (Value & 1)) {
			  if (memmode == 0) {
			    pager[3] = pager[2]; /* old port 7 value */
			    pager[2] = pager[1]; /* old port 6 value */
			    pager[1] = 0x20; /* ram page 0 */
			  }
			  else {
			    pager[1] = pager[2]; /* old port 6 value */
			    pager[2] = pager[3]; /* old port 7 value */
			    pager[3] = 0x20; /* ram page 0 */
			  }
			}
			memmode = Value & 1;
			break;
	
		case 0x06:
		  pager[1+memmode] = Value<0x20 ? Value : 0x20 | (Value & 1);
			break;

		case 0x07:
		  pager[2+memmode] = Value<0x20 ? Value : 0x20 | (Value & 1);
			break;

		case 0x10:
			LCDDriver(Value);
			break;

		case 0x11:
			lcdshow = 1;
			LCDOut(Value);
			break;

	case 0x14:
	  if (x7_protectport(0x14))
	    flashlock = Value&1;
	  break;
	}

	return;
}


/* void x7_emkeyin(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */

/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i == 40) { */
/* 		onkey = -1; */
/* 		return; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] &= ~(1 << (i & 0x07)); */

/* 	return; */
/* } */


/* void x7_emkeyup(unsigned short keyv, byte i) */
/* { */
/* 	if (i == 0xFF) { */
/* 		i = 0; */
/* 		while ((keyv != keycodes[i]) && (i < sizeof keycodes)) */
/* 			i++; */

/* /\* Support for 2nd Enter Key *\/ */
/* 		if (keyv == GDK_KP_Enter) */
/* 			i = 0x08; */
/* 	} */

/* 	if (i == 40) { */
/* 	  onkey = 0; */
/* 	  return; */
/* 	} */

/* 	if (i != sizeof keycodes) */
/* 		scode[i >> 3] |= 1 << (i & 0x07); */

/* 	return; */
/* } */


int x7_protectport(byte portaddr)
{
  /* Note this is not as strong as TI's protection (which monitors the
   * data bus and requires you to actually execute the instructions
   * NOP, NOP, IM 1, DI.)  This only requires the appropriate sequence
   * of instructions to be present in memory.
   */

  unsigned long pa;

  byte unprotect_opstring[] = {0x00,0x00,0xed,0x56,0xf3,0xd3};

  pa = (R.PC.W.l & 0x3FFF) + 0x4000*pager[(R.PC.W.l)>>14];

  if (pa < (0x1c*0x4000) || pa >= (0x20*0x4000)) {
    printf("** writing to port %02x from illegal address %06lx **\n",
	   portaddr,pa);
    return 0;
  }

  if (memcmp(mpages+pa-7,unprotect_opstring,6) || mpages[pa-1]!=portaddr) {
    printf("** writing to port %02x without proper unlock sequence **\n",
	   portaddr);
    return 0;
  }

  return 1;
}
