/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.tibennetwork.iarcade.CommandLineArguments;
import org.tibennetwork.iarcade.MameBinaryNotFoundException;
import org.tibennetwork.iarcade.internetarchive.FileNotFoundInCollectionException;
import org.tibennetwork.iarcade.internetarchive.MessAndMameCollections;
import org.tibennetwork.iarcade.internetarchive.NoWritableRomPathException;
import org.tibennetwork.iarcade.mame.CommandLineOptions;
import org.tibennetwork.iarcade.mame.CommandLineOptionsFactory;
import org.tibennetwork.iarcade.mame.InvalidMameArgumentsException;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MachineRepository;
import org.tibennetwork.iarcade.mame.MameExecutionException;
import org.tibennetwork.iarcade.mame.MameRuntime;
import org.tibennetwork.iarcade.mame.MameRuntimeImpl;
import org.tibennetwork.iarcade.mame.MameVersion;
import org.tibennetwork.iarcade.mame.Software;
import org.tibennetwork.iarcade.mame.SoftwareRepository;
import org.tibennetwork.iarcade.mame.UnhandledMameVersionPatternException;

public class IaRcade {
    public static void main(String[] args) {
        MameRuntimeImpl mame = null;
        String mameBinary = null;
        CommandLineOptions mameOptions = null;
        CommandLineArguments cliArgs = null;
        try {
            mameBinary = IaRcade.findMameBinary();
        }
        catch (MameBinaryNotFoundException e) {
            IaRcade.errorAndExit(e.getMessage());
        }
        try {
            mame = new MameRuntimeImpl(mameBinary);
            IaRcade.info("Mame version: " + mame.getVersion());
            mameOptions = new CommandLineOptionsFactory().deduceFromMameRuntime(mame);
        }
        catch (IOException | InterruptedException | ParseException | MameExecutionException | UnhandledMameVersionPatternException e) {
            IaRcade.errorAndExit("An error occured while trying to execute Mame: " + e.getMessage());
        }
        try {
            cliArgs = new CommandLineArguments(mameOptions, args);
            cliArgs.validate();
            mame.setDefaultOptions(cliArgs.getMameOptionsRawArgs());
            IaRcade.downloadFilesIfNeeded(cliArgs, mame);
        }
        catch (InvalidMameArgumentsException e) {
            IaRcade.warn("An error occured while trying to parse command line: " + e.getMessage());
        }
        if (!cliArgs.contains("noexecmame")) {
            try {
                mame.execute(cliArgs.getMameRawArgs(), false);
            }
            catch (IOException | InterruptedException e) {
                IaRcade.errorAndExit("An error occured while trying to execute Mame: " + e.getMessage());
            }
        }
    }

    public static String findMameBinary() throws MameBinaryNotFoundException {
        File candidateMameBinary;
        String candidateMameBinaryPath;
        File mameBinary;
        String mameExecEnvVar = System.getenv("MAME_EXEC");
        IaRcade.debug(String.format("$MAME_EXEC: %s", mameExecEnvVar));
        if (mameExecEnvVar != null && (mameBinary = new File(mameExecEnvVar)).exists() && mameBinary.canExecute()) {
            IaRcade.debug("MAME binary found on MAME_EXEC environment variable");
            return mameExecEnvVar;
        }
        String[] possibleBinaryNames = new String[]{"mame", "mame64", "mame.exe", "mame64.exe"};
        String containingJarPath = null;
        try {
            containingJarPath = new File(IaRcade.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
            IaRcade.debug(String.format("ia-rcade directory: %s", containingJarPath));
        }
        catch (URISyntaxException e) {
            IaRcade.debug(e.getMessage());
        }
        for (String b : possibleBinaryNames) {
            candidateMameBinaryPath = containingJarPath + File.separator + b;
            candidateMameBinary = new File(candidateMameBinaryPath);
            if (!candidateMameBinary.exists() || !candidateMameBinary.canExecute()) continue;
            IaRcade.debug(String.format("Mame binary found on the same directory than ia-rcade: %s", candidateMameBinaryPath));
            return candidateMameBinaryPath;
        }
        String pathEnvVar = System.getenv("PATH");
        IaRcade.debug(String.format("$PATH: %s", pathEnvVar));
        for (String p : pathEnvVar.split(":")) {
            for (String b : possibleBinaryNames) {
                candidateMameBinaryPath = p + File.separator + b;
                candidateMameBinary = new File(candidateMameBinaryPath);
                if (!candidateMameBinary.exists() || !candidateMameBinary.canExecute()) continue;
                IaRcade.debug(String.format("Mame binary found on $PATH : %s", candidateMameBinaryPath));
                return candidateMameBinaryPath;
            }
        }
        throw new MameBinaryNotFoundException("MAME executable has not been found");
    }

    private static void downloadFilesIfNeeded(CommandLineArguments mameArgs, MameRuntime mame) throws InvalidMameArgumentsException {
        if (mameArgs.containsMameCommand()) {
            return;
        }
        CommandLineArguments.ExtractedMachineAndSoftwares ems = null;
        try {
            ems = mameArgs.extractMachineAndSoftwares(new MachineRepository(mame), new SoftwareRepository(mame));
        }
        catch (IOException | InterruptedException e) {
            IaRcade.errorAndExit("An error occured " + e.getMessage());
        }
        Machine machine = ems.getMachine();
        Set<File> romsPaths = null;
        File writableRomPath = null;
        try {
            romsPaths = mame.getRomsPaths();
            writableRomPath = mame.getWritableRomPath();
        }
        catch (IOException | InterruptedException | ParseException e) {
            IaRcade.errorAndExit("An error occured while trying to execute Mame: " + e.getMessage());
        }
        catch (NoWritableRomPathException e) {
            IaRcade.errorAndExit(e.getMessage());
        }
        MameVersion version = mame.getVersion();
        MessAndMameCollections collections = new MessAndMameCollections();
        try {
            collections.download(machine, version, romsPaths, writableRomPath);
        }
        catch (FileNotFoundInCollectionException e) {
            IaRcade.warn(e.getMessage());
        }
        if (ems.hasSoftwares()) {
            List<Software> softwares = ems.getSoftwares();
            for (Software software : softwares) {
                if (software.isRegularFile()) {
                    return;
                }
                try {
                    collections.download(software, version, romsPaths, writableRomPath);
                }
                catch (FileNotFoundInCollectionException e) {
                    IaRcade.warn(e.getMessage());
                }
            }
        }
    }

    public static void errorAndExit(String message) {
        System.err.println("[ia-rcade error]: " + message);
        System.exit(1);
    }

    public static void debug(String message) {
        if (System.getProperties().containsKey("iarcade.debug") && System.getProperty("iarcade.debug").equals("1")) {
            System.err.println("[ia-rcade debug]: " + message);
        }
    }

    public static void warn(String message) {
        System.err.println("[ia-rcade warn]: " + message);
    }

    public static void info(String message) {
        System.out.println("[ia-rcade info]: " + message);
    }
}

