/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;

public class MachineChdSetFile {
    @XmlElement(name="collectionId")
    private final String collectionId;
    @XmlElement(name="machine")
    private final String machine;
    @XmlElement(name="chd")
    private final String chd;
    @XmlElement(name="url")
    private final URL url;
    @XmlElement(name="size")
    private final long size;

    public MachineChdSetFile(String collectionId, String machine, String chd, URL url, long size) {
        this.collectionId = collectionId;
        this.machine = machine;
        this.chd = chd;
        this.url = url;
        this.size = size;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getChd() {
        return this.chd;
    }

    public URL getUrl() {
        return this.url;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(this.url.toString(), "UTF-8");
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
        }
        Pattern p = Pattern.compile(".+(/[^/]+/[^/]+\\.chd)");
        Matcher m = p.matcher(decodedUrl);
        if (m.matches()) {
            return m.group(1);
        }
        throw new RuntimeException("Can't extract file name from url: " + this.url);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MachineRomSetFile: [machine: ");
        builder.append(this.machine);
        builder.append(", chd: ");
        builder.append(this.chd);
        builder.append(", url: ");
        builder.append(this.url);
        builder.append(", size: ");
        builder.append(this.size);
        return builder.toString();
    }

    public MachineChdSetFile() {
        this.collectionId = null;
        this.machine = null;
        this.chd = null;
        this.url = null;
        this.size = 0L;
    }
}

