/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.internetarchive.MachineRomSetFile;
import org.tibennetwork.iarcade.internetarchive.MachineRomSetFileXmlAdapter;
import org.tibennetwork.iarcade.internetarchive.RomSet;
import org.tibennetwork.iarcade.mame.MameVersion;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MachineRomSet
extends RomSet {
    public static TreeSet<MameVersion> versions = new TreeSet();
    @XmlElement(name="format")
    private final MachineRomSetFormat format;
    @XmlJavaTypeAdapter(value=MachineRomSetFileXmlAdapter.class)
    private final Map<String, MachineRomSetFile> files;

    public MachineRomSet(MameVersion version, Set<Collection> collections, MachineRomSetFormat format, Map<String, MachineRomSetFile> files) {
        super(version, collections);
        this.format = format;
        this.files = files;
    }

    public static MachineRomSet createFromVersion(MameVersion version) {
        StringBuilder builder = new StringBuilder("machine-rom-set/");
        builder.append(version);
        builder.append(".xml");
        InputStream stream = MachineRomSet.class.getClassLoader().getResourceAsStream(builder.toString());
        return JAXB.unmarshal(stream, MachineRomSet.class);
    }

    public static Iterator<MachineRomSet> getRomSets(MameVersion version) {
        if (!versions.contains(version)) {
            IaRcade.warn("No archive.org machine ROM set matches your Mame version");
            IaRcade.warn("Some files might not be available.");
        }
        final Iterator<MameVersion> iter = versions.headSet(version, true).descendingIterator();
        return new Iterator<MachineRomSet>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public MachineRomSet next() {
                return MachineRomSet.createFromVersion((MameVersion)iter.next());
            }
        };
    }

    public MachineRomSetFormat getFormat() {
        return this.format;
    }

    public Map<String, MachineRomSetFile> getFiles() {
        return this.files;
    }

    public boolean contains(String machineName) {
        return this.files.containsKey(machineName);
    }

    public void download(File writableRomPath, String machineName) {
        MachineRomSetFile file = this.files.get(machineName);
        Collection col = this.getCollection(file.getCollectionId());
        StringBuilder builder = new StringBuilder("Found ");
        builder.append(file.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("Collection: ");
        builder.append(col.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("URL: ");
        builder.append(col.getUrl());
        IaRcade.info(builder.toString());
        builder = new StringBuilder(writableRomPath.getAbsolutePath());
        builder.append(File.separator);
        builder.append(file.getName());
        String destPath = builder.toString();
        this.downloadFile(file.getUrl(), destPath, file.getSize());
    }

    public MachineRomSet() {
        super(null, null);
        this.format = null;
        this.files = null;
    }

    static {
        versions.add(new MameVersion("0.149"));
        versions.add(new MameVersion("0.151"));
        versions.add(new MameVersion("0.161"));
        versions.add(new MameVersion("0.185"));
        versions.add(new MameVersion("0.193"));
        versions.add(new MameVersion("0.197"));
        versions.add(new MameVersion("0.202"));
    }

    public static enum MachineRomSetFormat {
        SPLIT,
        MERGED;

    }
}

