/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;

public class SoftwareListChdSetFile {
    @XmlElement(name="collectionId")
    private final String collectionId;
    @XmlElement(name="softwareList")
    private final String softwareList;
    @XmlElement(name="software")
    private final String software;
    @XmlElement(name="chd")
    private final String chd;
    @XmlElement(name="url")
    private final URL url;
    @XmlElement(name="size")
    private final long size;

    public SoftwareListChdSetFile(String collectionId, String softwareList, String software, String chd, URL url, long size) {
        this.collectionId = collectionId;
        this.softwareList = softwareList;
        this.software = software;
        this.chd = chd;
        this.url = url;
        this.size = size;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getSoftwareList() {
        return this.softwareList;
    }

    public String getSoftware() {
        return this.software;
    }

    public String getChd() {
        return this.chd;
    }

    public URL getUrl() {
        return this.url;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(this.url.toString(), "UTF-8");
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
        }
        Pattern p = Pattern.compile(".+(/[^/]+/[^/]+\\.chd)");
        Matcher m = p.matcher(decodedUrl);
        if (m.matches()) {
            return this.softwareList + m.group(1);
        }
        throw new RuntimeException("Can't extract file name from url: " + this.url);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SoftwareFileChdSetFile: [softwareList: ");
        builder.append(this.softwareList);
        builder.append(", software: ");
        builder.append(this.software);
        builder.append(", chd: ");
        builder.append(this.chd);
        builder.append(", url: ");
        builder.append(this.url);
        builder.append(", size: ");
        builder.append(this.size);
        return builder.toString();
    }

    public SoftwareListChdSetFile() {
        this.collectionId = null;
        this.softwareList = null;
        this.software = null;
        this.chd = null;
        this.url = null;
        this.size = 0L;
    }
}

