/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.internetarchive.RomSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListRomSetFile;
import org.tibennetwork.iarcade.internetarchive.SoftwareListRomSetFileXmlAdapter;
import org.tibennetwork.iarcade.mame.MameVersion;

public class SoftwareListRomSet
extends RomSet {
    public static TreeSet<MameVersion> versions = new TreeSet();
    @XmlJavaTypeAdapter(value=SoftwareListRomSetFileXmlAdapter.class)
    private final Map<String, Map<String, SoftwareListRomSetFile>> files;

    public SoftwareListRomSet(MameVersion version, Set<Collection> collections, Map<String, Map<String, SoftwareListRomSetFile>> files) {
        super(version, collections);
        this.files = files;
    }

    public static SoftwareListRomSet findBest(MameVersion version) {
        MameVersion bestVersion;
        if (versions.contains(version)) {
            bestVersion = version;
        } else {
            bestVersion = versions.floor(version);
            IaRcade.warn("No archive.org softlist ROM set matches your Mame version");
            IaRcade.warn("Some files might not be available.");
        }
        StringBuilder builder = new StringBuilder("softwarelist-rom-set/");
        builder.append(bestVersion);
        builder.append(".xml");
        InputStream stream = SoftwareListRomSet.class.getClassLoader().getResourceAsStream(builder.toString());
        SoftwareListRomSet romSet = JAXB.unmarshal(stream, SoftwareListRomSet.class);
        return romSet;
    }

    public Map<String, Map<String, SoftwareListRomSetFile>> getFiles() {
        return this.files;
    }

    public boolean contains(String listName, String name) {
        Map<String, SoftwareListRomSetFile> softFiles = this.files.get(listName);
        if (softFiles == null) {
            return false;
        }
        return softFiles.containsKey(name);
    }

    public void download(File writableRomPath, String listName, String name) {
        SoftwareListRomSetFile file = this.files.get(listName).get(name);
        Collection col = this.getCollection(file.getCollectionId());
        StringBuilder builder = new StringBuilder("Found ");
        builder.append(file.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("Collection: ");
        builder.append(col.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("URL: ");
        builder.append(col.getUrl());
        IaRcade.info(builder.toString());
        builder = new StringBuilder(writableRomPath.getAbsolutePath());
        builder.append(File.separator);
        builder.append(file.getName());
        String destPath = builder.toString();
        this.downloadFile(file.getUrl(), destPath, file.getSize());
    }

    public SoftwareListRomSet() {
        super(null, null);
        this.files = null;
    }

    static {
        versions.add(new MameVersion("0.149"));
        versions.add(new MameVersion("0.151"));
        versions.add(new MameVersion("0.185"));
        versions.add(new MameVersion("0.193"));
        versions.add(new MameVersion("0.202"));
    }
}

