/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.mame;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.tibennetwork.iarcade.internetarchive.MachineRomSet;
import org.tibennetwork.iarcade.mame.MachineHasNoSoftwareListException;
import org.tibennetwork.iarcade.mame.MediaDevice;
import org.tibennetwork.iarcade.mame.SoftwareList;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Machine {
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlAttribute(name="runnable")
    private Boolean isRunnable;
    @XmlAttribute(name="romof")
    private String romof = null;
    @XmlAttribute(name="cloneof")
    private String cloneof = null;
    @XmlElement(name="softwarelist")
    private List<SoftwareList> softwareLists;
    @XmlElement(name="rom")
    private List<Rom> roms = new ArrayList<Rom>();
    @XmlElement(name="disk")
    private List<MachineDisk> disks = new ArrayList<MachineDisk>();
    @XmlElement(name="device")
    private List<MediaDevice> devices = new ArrayList<MediaDevice>();
    private Set<Machine> subMachines = new HashSet<Machine>();
    private Machine clonedMachine;
    private Machine romOfMachine;

    public Boolean IsRunnable() {
        return this.isRunnable;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCloneof() {
        return this.cloneof;
    }

    public String getRomof() {
        return this.romof;
    }

    public List<SoftwareList> getSoftwareLists() {
        return this.softwareLists;
    }

    public List<Rom> getRoms() {
        return this.roms;
    }

    public Set<Machine> getSubMachines() {
        return this.subMachines;
    }

    public void setSubMachines(Set<Machine> subMachines) {
        this.subMachines = subMachines;
    }

    public Machine getClonedMachine() {
        return this.clonedMachine;
    }

    public void setClonedMachine(Machine clonedMachine) {
        this.clonedMachine = clonedMachine;
    }

    public Machine getRomOfMachine() {
        return this.romOfMachine;
    }

    public void setRomOfMachine(Machine romOfMachine) {
        this.romOfMachine = romOfMachine;
    }

    public List<MediaDevice> getMediaDevices() {
        ArrayList<MediaDevice> mediaDevices = new ArrayList<MediaDevice>();
        for (MediaDevice d : this.devices) {
            if (!d.hasMediaInterface() || !d.hasInstance()) continue;
            mediaDevices.add(d);
        }
        return mediaDevices;
    }

    private Set<String> getNeededRomFiles(MachineRomSet.MachineRomSetFormat format) {
        Set<String> psRomSets;
        HashSet<String> romSets = new HashSet<String>();
        if (!this.roms.isEmpty() && (this.clonedMachine == null || format.equals((Object)MachineRomSet.MachineRomSetFormat.SPLIT))) {
            romSets.add(this.name);
        }
        if (this.clonedMachine != null && !(psRomSets = this.clonedMachine.getNeededRomFiles(format)).isEmpty()) {
            romSets.addAll(psRomSets);
        }
        if (this.romOfMachine != null && !(psRomSets = this.romOfMachine.getNeededRomFiles(format)).isEmpty()) {
            romSets.addAll(psRomSets);
        }
        for (Machine subm : this.getSubMachines()) {
            Set<String> submRomSets = subm.getNeededRomFiles(format);
            if (submRomSets.isEmpty()) continue;
            romSets.addAll(submRomSets);
        }
        return romSets;
    }

    private Set<String> getNeededChdFiles() {
        HashSet<String> chds = new HashSet<String>();
        if (!this.disks.isEmpty()) {
            for (MachineDisk d : this.disks) {
                chds.add(d.getName() + ".chd");
            }
        }
        return chds;
    }

    public Set<String> getMissingRomFiles(MachineRomSet.MachineRomSetFormat format, Set<File> romPaths) {
        HashSet<String> missingRomFiles = new HashSet<String>();
        block0: for (String romFile : this.getNeededRomFiles(format)) {
            for (File romPath : romPaths) {
                String romFileInRomPathWithoutExtension = romPath.getAbsolutePath() + File.separator + romFile;
                File zippedRomFileInRomPath = new File(romFileInRomPathWithoutExtension + ".zip");
                File SevenZippedRomFileInRomPath = new File(romFileInRomPathWithoutExtension + ".7z");
                if (!zippedRomFileInRomPath.exists() && !SevenZippedRomFileInRomPath.exists()) continue;
                continue block0;
            }
            missingRomFiles.add(romFile);
        }
        return missingRomFiles;
    }

    public Set<String> getMissingChdFiles(Set<File> romPaths) {
        HashSet<String> missingChdFiles = new HashSet<String>();
        block0: for (String chdFile : this.getNeededChdFiles()) {
            for (File romPath : romPaths) {
                File chdFileInRomPath = new File(romPath.getAbsolutePath() + File.separator + this.name + File.separator + chdFile);
                if (!chdFileInRomPath.exists()) continue;
                continue block0;
            }
            missingChdFiles.add(chdFile);
        }
        return missingChdFiles;
    }

    public boolean areRomFilesAvailable(MachineRomSet.MachineRomSetFormat format, Set<File> romPaths) {
        return this.getMissingRomFiles(format, romPaths).size() == 0;
    }

    public SoftwareList getSoftwareList(MediaDevice md) throws MachineHasNoSoftwareListException {
        String softwareListName = String.format("%s_%s", this.name, md.getBriefname());
        for (SoftwareList sl : this.softwareLists) {
            if (sl.getName() != softwareListName) continue;
            return sl;
        }
        throw new MachineHasNoSoftwareListException(String.format("There is no %s softwarelist available for machine %s", md.getBriefname(), this.getDescription()));
    }

    public String toString() {
        return String.format("Machine: [name: %s]", this.name);
    }

    @XmlRootElement(name="disk")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class MachineDisk {
        @XmlAttribute(name="name")
        String name;

        MachineDisk() {
        }

        public String getName() {
            return this.name;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Rom {
        @XmlAttribute(name="name")
        private String name;

        Rom() {
        }

        public String getName() {
            return this.name;
        }
    }
}

