/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.mame;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.ParseException;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.NoWritableRomPathException;
import org.tibennetwork.iarcade.mame.MameExecutionException;
import org.tibennetwork.iarcade.mame.MameRuntime;
import org.tibennetwork.iarcade.mame.MameVersion;
import org.tibennetwork.iarcade.mame.UnhandledMameVersionPatternException;

public class MameRuntimeImpl
implements MameRuntime {
    private String binPath;
    private String[] defaultOptions;
    private String binDirectory;
    private Set<File> romsPaths;
    private MameVersion version;

    public MameRuntimeImpl(String binPath) throws IOException, InterruptedException, ParseException, UnhandledMameVersionPatternException {
        this.binPath = binPath;
        this.binDirectory = new File(binPath).getParent();
        IaRcade.debug(String.format("Mame binary directory: %s", this.binDirectory));
        this.getVersionFromBinary();
    }

    @Override
    public void setDefaultOptions(String[] defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @Override
    public Set<File> getRomsPaths() throws IOException, InterruptedException, ParseException {
        if (this.romsPaths == null) {
            this.getRomsPathsFromBinary();
        }
        return this.romsPaths;
    }

    @Override
    public void execute(String[] rawArgs, boolean mergeArgsWithDefaultOptions) throws IOException, InterruptedException {
        this.initMameProcess(rawArgs, true, mergeArgsWithDefaultOptions).waitFor();
    }

    @Override
    public void execute(String[] rawArgs) throws IOException, InterruptedException {
        this.execute(rawArgs, true);
    }

    @Override
    public List<String> executeAndReturnStdout(String[] rawArgs, boolean mergeArgsWithDefaultOptions) throws IOException, InterruptedException, MameExecutionException {
        String s;
        Process mameProcess = this.initMameProcess(rawArgs, false, mergeArgsWithDefaultOptions);
        BufferedReader mameRuntimeStdout = new BufferedReader(new InputStreamReader(mameProcess.getInputStream()));
        ArrayList<String> stdout = new ArrayList<String>();
        while ((s = mameRuntimeStdout.readLine()) != null) {
            stdout.add(s);
        }
        int exitValue = mameProcess.waitFor();
        if (exitValue != 0) {
            throw new MameExecutionException(String.format("Mame process returned exit value %s", exitValue));
        }
        return stdout;
    }

    @Override
    public List<String> executeAndReturnStdout(String[] rawArgs) throws IOException, InterruptedException, MameExecutionException {
        return this.executeAndReturnStdout(rawArgs, true);
    }

    @Override
    public InputStream executeAndReturnStdoutAsInputStream(String[] rawArgs, boolean mergeArgsWithDefaultOptions) throws IOException, InterruptedException, MameExecutionException {
        return this.initMameProcess(rawArgs, false, mergeArgsWithDefaultOptions).getInputStream();
    }

    @Override
    public InputStream executeAndReturnStdoutAsInputStream(String[] rawArgs) throws IOException, InterruptedException, MameExecutionException {
        return this.executeAndReturnStdoutAsInputStream(rawArgs, true);
    }

    @Override
    public File getWritableRomPath() throws NoWritableRomPathException {
        for (File f : this.romsPaths) {
            if (!f.isDirectory() || !f.canWrite()) continue;
            return f;
        }
        throw new NoWritableRomPathException("No writable path to write roms into");
    }

    @Override
    public MameVersion getVersion() {
        return this.version;
    }

    private Process initMameProcess(String[] rawArgs, boolean inheritIO, boolean mergeArgsWithDefaultOptions) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.binPath);
        if (mergeArgsWithDefaultOptions) {
            args.addAll(Arrays.asList(this.defaultOptions));
        }
        args.addAll(Arrays.asList(rawArgs));
        IaRcade.debug("Executes Mame with: " + args);
        ProcessBuilder builder = new ProcessBuilder(args);
        if (inheritIO) {
            builder.inheritIO();
        }
        builder.directory(new File(this.binDirectory));
        return builder.start();
    }

    private void getVersionFromBinary() throws IOException, InterruptedException, UnhandledMameVersionPatternException {
        String[] rawArgs = new String[]{"-help"};
        List<String> mameStdout = null;
        try {
            mameStdout = this.executeAndReturnStdout(rawArgs, false);
        }
        catch (MameExecutionException e) {
            throw (RuntimeException)new RuntimeException("Unhandled error occured while launching mame using -help to obtain version").initCause(e);
        }
        this.version = MameVersion.parseFromHelpOutput(mameStdout.get(0));
    }

    private void getRomsPathsFromBinary() throws IOException, InterruptedException, ParseException {
        String[] rawArgs = new String[]{"-showconfig"};
        List<String> mameStdout = null;
        try {
            mameStdout = this.executeAndReturnStdout(rawArgs);
        }
        catch (MameExecutionException e) {
            throw (RuntimeException)new RuntimeException("Unhandled error occured while launching mame to fetch rompaths").initCause(e);
        }
        this.romsPaths = new HashSet<File>();
        Pattern p = Pattern.compile("^rompath +(.*)$");
        for (String s : mameStdout) {
            Matcher m = p.matcher(s);
            if (!m.matches()) continue;
            String originalCwd = System.getProperty("user.dir");
            System.setProperty("user.dir", this.binDirectory);
            for (String path : m.group(1).split(";")) {
                path = path.replace("$HOME", System.getProperty("user.home"));
                File dir = new File(path);
                if (!(dir = new File(dir.getAbsolutePath())).isDirectory()) continue;
                IaRcade.debug("rompath found: " + dir);
                this.romsPaths.add(dir);
            }
            System.setProperty("user.dir", originalCwd);
            break;
        }
    }
}

