/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.tibennetwork.iarcade.mame.CommandLineOptions;
import org.tibennetwork.iarcade.mame.InvalidMameArgumentsException;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MachineDoesntExistException;
import org.tibennetwork.iarcade.mame.MachineHasNoSoftwareListException;
import org.tibennetwork.iarcade.mame.MachineRepository;
import org.tibennetwork.iarcade.mame.MediaDevice;
import org.tibennetwork.iarcade.mame.Software;
import org.tibennetwork.iarcade.mame.SoftwareNotFoundInSoftwareListsException;
import org.tibennetwork.iarcade.mame.SoftwareRepository;

public class CommandLineArguments {
    private Options iaRcadeOptions;
    private CommandLineOptions mameOptions;
    private String[] rawArgs;
    private CommandLine commandLine = null;

    public CommandLineArguments(CommandLineOptions mameOptions, String[] rawArgs) throws InvalidMameArgumentsException {
        this.mameOptions = mameOptions;
        this.iaRcadeOptions = this.buildIaRcadeOptions();
        this.rawArgs = rawArgs;
    }

    public boolean contains(String optionName) {
        return this.commandLine.hasOption(optionName);
    }

    public boolean containsMameCommand() {
        for (Option cmd : this.mameOptions.getCommands().getOptions()) {
            if (!this.commandLine.hasOption(cmd.getOpt())) continue;
            return true;
        }
        return false;
    }

    public String[] getMameRawArgs() {
        ArrayList<Object> mra = new ArrayList<Object>();
        block0: for (Option o : this.commandLine.getOptions()) {
            for (Option ia : this.iaRcadeOptions.getOptions()) {
                if (!o.getOpt().equals(ia.getOpt())) continue;
                continue block0;
            }
            mra.add('-' + o.getOpt());
            if (!o.hasArg() && !o.hasArgs()) continue;
            for (String a : this.commandLine.getOptionValues(o.getOpt())) {
                mra.add(a);
            }
        }
        for (String arg : this.commandLine.getArgs()) {
            mra.add(arg);
        }
        return mra.toArray(new String[mra.size()]);
    }

    public String[] getMameOptionsRawArgs() {
        ArrayList<String> roa = new ArrayList<String>();
        block0: for (Option o : this.commandLine.getOptions()) {
            for (Option cmd : this.mameOptions.getCommands().getOptions()) {
                if (!o.getOpt().equals(cmd.getOpt())) continue;
                continue block0;
            }
            for (Option mt : this.mameOptions.getMediaTypes().getOptions()) {
                if (!o.getOpt().equals(mt.getOpt())) continue;
                continue block0;
            }
            for (Option ia : this.iaRcadeOptions.getOptions()) {
                if (!o.getOpt().equals(ia.getOpt())) continue;
                continue block0;
            }
            roa.add('-' + o.getOpt());
            if (!o.hasArg() && !o.hasArgs()) continue;
            for (String a : this.commandLine.getOptionValues(o.getOpt())) {
                roa.add(a);
            }
        }
        return roa.toArray(new String[roa.size()]);
    }

    public ExtractedMachineAndSoftwares extractMachineAndSoftwares(MachineRepository mr, SoftwareRepository sr) throws InvalidMameArgumentsException, IOException, InterruptedException {
        ExtractedMachineAndSoftwares ems = new ExtractedMachineAndSoftwares();
        String[] cmdArgs = this.commandLine.getArgs();
        if (cmdArgs.length > 2) {
            throw new InvalidMameArgumentsException("Too many non option args");
        }
        Machine m = null;
        if (cmdArgs.length >= 1) {
            try {
                m = mr.findByName(cmdArgs[0]);
                ems.setMachine(m);
            }
            catch (MachineDoesntExistException e) {
                throw (InvalidMameArgumentsException)new InvalidMameArgumentsException(e.getMessage()).initCause(e);
            }
            if (cmdArgs.length > 1) {
                if (this.isRegularSoftwareFile(cmdArgs[1])) {
                    throw new InvalidMameArgumentsException("The software must be a software name from software list and not a regular file");
                }
                try {
                    ems.getSoftwares().add(sr.findByMachineAndByName(m, cmdArgs[1]));
                }
                catch (MachineDoesntExistException | MachineHasNoSoftwareListException | SoftwareNotFoundInSoftwareListsException e) {
                    throw (InvalidMameArgumentsException)new InvalidMameArgumentsException(e.getMessage()).initCause(e);
                }
            }
            for (MediaDevice md : m.getMediaDevices()) {
                Software s;
                if (!this.commandLine.hasOption(md.getBriefname())) continue;
                String softwareName = this.commandLine.getOptionValue(md.getBriefname());
                if (this.isRegularSoftwareFile(softwareName)) {
                    s = new Software(m, md, softwareName);
                } else {
                    try {
                        s = sr.findByMachineAndAndByMediaTypeAndByName(m, md, softwareName);
                    }
                    catch (MachineDoesntExistException | MachineHasNoSoftwareListException | SoftwareNotFoundInSoftwareListsException e) {
                        throw (InvalidMameArgumentsException)new InvalidMameArgumentsException(e.getMessage()).initCause(e);
                    }
                }
                ems.getSoftwares().add(s);
            }
        }
        return ems;
    }

    public void validate() throws InvalidMameArgumentsException {
        Options mergedOptions = new Options();
        for (Option o : this.mameOptions.getAllOptions().getOptions()) {
            mergedOptions.addOption(o);
        }
        for (Option o : this.iaRcadeOptions.getOptions()) {
            mergedOptions.addOption(o);
        }
        try {
            DefaultParser parser = new DefaultParser();
            this.commandLine = parser.parse(mergedOptions, this.rawArgs);
        }
        catch (ParseException e) {
            throw (InvalidMameArgumentsException)new InvalidMameArgumentsException(e.getMessage()).initCause(e);
        }
    }

    private boolean isRegularSoftwareFile(String name) {
        return !FilenameUtils.getExtension(name).isEmpty() || new File(name).exists();
    }

    private Options buildIaRcadeOptions() {
        Options opts = new Options();
        opts.addOption("noexecmame", false, "");
        return opts;
    }

    public static class ExtractedMachineAndSoftwares {
        private Machine machine = null;
        private List<Software> softwares = new ArrayList<Software>();

        public boolean hasMachine() {
            return this.machine != null;
        }

        public Machine getMachine() {
            return this.machine;
        }

        public void setMachine(Machine m) {
            this.machine = m;
        }

        public List<Software> getSoftwares() {
            return this.softwares;
        }

        public boolean hasSoftwares() {
            return this.softwares != null;
        }
    }
}

