/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.internetarchive.MachineChdSetFile;
import org.tibennetwork.iarcade.internetarchive.MachineChdSetFileXmlAdapter;
import org.tibennetwork.iarcade.internetarchive.RomSet;
import org.tibennetwork.iarcade.mame.MameVersion;

public class MachineChdSet
extends RomSet {
    public static TreeSet<MameVersion> versions = new TreeSet();
    @XmlJavaTypeAdapter(value=MachineChdSetFileXmlAdapter.class)
    private final Map<String, Map<String, MachineChdSetFile>> files;

    public MachineChdSet(MameVersion version, Set<Collection> collections, Map<String, Map<String, MachineChdSetFile>> files) {
        super(version, collections);
        this.files = files;
    }

    public static MachineChdSet findBest(MameVersion version) {
        MameVersion bestVersion;
        if (versions.contains(version)) {
            bestVersion = version;
        } else {
            bestVersion = versions.floor(version);
            IaRcade.warn("No archive.org machine CHD set matches your Mame version");
            IaRcade.warn("Some files might not be available.");
        }
        StringBuilder builder = new StringBuilder("machine-chd-set/");
        builder.append(bestVersion);
        builder.append(".xml");
        InputStream stream = MachineChdSet.class.getClassLoader().getResourceAsStream(builder.toString());
        MachineChdSet chdSet = JAXB.unmarshal(stream, MachineChdSet.class);
        return chdSet;
    }

    public boolean contains(String machine, String chd) {
        if (this.files.containsKey(machine)) {
            return this.files.get(machine).containsKey(chd);
        }
        return false;
    }

    public void download(File writableRomPath, String machineName, String chdName) {
        MachineChdSetFile chd = this.files.get(machineName).get(chdName);
        Collection col = this.getCollection(chd.getCollectionId());
        StringBuilder builder = new StringBuilder("Found ");
        builder.append(chd.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("Collection: ");
        builder.append(col.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("URL: ");
        builder.append(col.getUrl());
        IaRcade.info(builder.toString());
        builder = new StringBuilder(writableRomPath.getAbsolutePath());
        builder.append(File.separator);
        builder.append(chd.getName());
        String destPath = builder.toString();
        this.downloadFile(chd.getUrl(), destPath, chd.getSize());
    }

    public MachineChdSet() {
        super(null, null);
        this.files = null;
    }

    static {
        versions.add(new MameVersion("0.149"));
        versions.add(new MameVersion("0.161"));
        versions.add(new MameVersion("0.185"));
        versions.add(new MameVersion("0.193"));
    }
}

