/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.tibennetwork.iarcade.internetarchive.FileNotFoundInCollectionException;
import org.tibennetwork.iarcade.internetarchive.MachineChdSet;
import org.tibennetwork.iarcade.internetarchive.MachineRomSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListChdSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListRomSet;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MameVersion;
import org.tibennetwork.iarcade.mame.Software;
import org.tibennetwork.iarcade.mame.SoftwareChdFile;
import org.tibennetwork.iarcade.mame.SoftwareRomFile;

public class MessAndMameCollections {
    public void download(Machine machine, MameVersion version, Set<File> romsPaths, File writableRomPath) throws FileNotFoundInCollectionException {
        Iterator<MachineRomSet> iterator = MachineRomSet.getRomSets(version);
        boolean neededRomsFoundInSets = false;
        block0: while (iterator.hasNext()) {
            MachineRomSet romSet = iterator.next();
            Set<String> missingRoms = machine.getMissingRomFiles(romSet.getFormat(), romsPaths);
            for (String rom : missingRoms) {
                if (romSet.contains(rom)) continue;
                continue block0;
            }
            neededRomsFoundInSets = true;
            for (String rom : missingRoms) {
                romSet.download(writableRomPath, rom);
            }
        }
        if (!neededRomsFoundInSets) {
            StringBuilder builder = new StringBuilder("Required rom files for machine '");
            builder.append(machine.getName());
            builder.append("' can't be found in any IA romset collections");
            throw new FileNotFoundInCollectionException(builder.toString());
        }
        String machineName = machine.getName();
        Set<String> missingChds = machine.getMissingChdFiles(romsPaths);
        if (!missingChds.isEmpty()) {
            MachineChdSet chdSet = MachineChdSet.findBest(version);
            for (String chd : missingChds) {
                if (chdSet.contains(machineName, chd)) {
                    chdSet.download(writableRomPath, machineName, chd);
                    continue;
                }
                StringBuilder builder = new StringBuilder("Required CHD file '");
                builder.append(chd);
                builder.append("' for machine '");
                builder.append(machineName);
                builder.append("' can't be found in IA romset collections ");
                builder.append(chdSet.getVersion());
                throw new FileNotFoundInCollectionException(builder.toString());
            }
        }
    }

    public void download(Software software, MameVersion version, Set<File> romsPaths, File writableRomPath) throws FileNotFoundInCollectionException {
        Set<SoftwareChdFile> missingFiles;
        Set<SoftwareRomFile> missingRomFiles = software.getMissingRomFiles(romsPaths);
        if (!missingRomFiles.isEmpty()) {
            SoftwareListRomSet romSet = SoftwareListRomSet.findBest(version);
            for (SoftwareRomFile rom : missingRomFiles) {
                if (romSet.contains(rom.getListName(), rom.getName())) {
                    romSet.download(writableRomPath, rom.getListName(), rom.getName());
                    continue;
                }
                StringBuilder builder = new StringBuilder("Required ROM files for software '");
                builder.append(rom.getName());
                builder.append("' can't be found in IA romset collections ");
                builder.append(romSet.getVersion());
                throw new FileNotFoundInCollectionException(builder.toString());
            }
        }
        if (!(missingFiles = software.getMissingChdFiles(romsPaths)).isEmpty()) {
            SoftwareListChdSet chdSet = SoftwareListChdSet.findBest(version);
            for (SoftwareChdFile chd : missingFiles) {
                if (chdSet.contains(chd.getListName(), chd.getSoftwareName(), chd.getName())) {
                    chdSet.download(writableRomPath, chd.getListName(), chd.getSoftwareName(), chd.getName());
                    continue;
                }
                StringBuilder builder = new StringBuilder("Required CHD file '");
                builder.append(chd.getName());
                builder.append("' for software '");
                builder.append(chd.getSoftwareName());
                builder.append("' can't be found in IA romset collections ");
                builder.append(chdSet.getVersion());
                throw new FileNotFoundInCollectionException(builder.toString());
            }
        }
    }
}

