/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.mame.MameVersion;

public abstract class RomSet {
    @XmlElement(name="version")
    protected final MameVersion version;
    @XmlElementWrapper(name="collections")
    @XmlElement(name="collection")
    protected final Set<Collection> collections;

    public RomSet(MameVersion version, Set<Collection> collections) {
        this.version = version;
        this.collections = collections;
    }

    public MameVersion getVersion() {
        return this.version;
    }

    public Set<Collection> getCollections() {
        return this.collections;
    }

    protected Collection getCollection(String collectionId) {
        Collection col = null;
        for (Collection c : this.collections) {
            if (!c.getId().equals(collectionId)) continue;
            col = c;
            break;
        }
        return col;
    }

    protected void downloadFile(URL url, String destPath, long size) {
        File dest = new File(destPath);
        IaRcade.debug("URL: " + url);
        dest.getParentFile().mkdirs();
        InputStream urlStream = null;
        FileOutputStream destStream = null;
        try {
            urlStream = url.openStream();
            destStream = new FileOutputStream(dest);
            int readBytes = 0;
            int downloadedBytes = 0;
            int downloadedPercent = 0;
            byte[] bytes = new byte[1024];
            boolean downloadingMessageDisplayed = false;
            size /= 1024L;
            String destName = dest.getName();
            String ellipsisedName = destName.length() > 18 ? destName.substring(0, 15) + "..." : destName;
            String downloadPrefix = "[ia-rcade info]: Downloading " + ellipsisedName;
            while ((readBytes = urlStream.read(bytes)) != -1) {
                ((OutputStream)destStream).write(bytes, 0, readBytes);
                downloadedPercent = (int)((float)((downloadedBytes += readBytes) / 1024) / (float)size * 100.0f);
                System.out.print(String.format("%s - %skB / %skB (%s)\r", downloadPrefix, downloadedBytes / 1024, size, downloadedPercent + "%"));
                downloadingMessageDisplayed = true;
            }
            if (downloadingMessageDisplayed) {
                System.out.println(downloadPrefix + " ...DONE                                          ");
            }
            urlStream.close();
            ((OutputStream)destStream).close();
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }
}

