/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.internetarchive.MachineChdSet;
import org.tibennetwork.iarcade.internetarchive.MachineChdSetFile;
import org.tibennetwork.iarcade.internetarchive.MachineRomSet;
import org.tibennetwork.iarcade.internetarchive.MachineRomSetFile;
import org.tibennetwork.iarcade.internetarchive.SoftwareListChdSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListChdSetFile;
import org.tibennetwork.iarcade.internetarchive.SoftwareListRomSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListRomSetFile;
import org.tibennetwork.iarcade.mame.MameVersion;

public class RomSetXmlGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String type = args[0];
        String path = args[1];
        String html = null;
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            html = sb.toString();
        }
        Document zipView = Jsoup.parse(html);
        switch (type) {
            case "machine-rom": {
                RomSetXmlGenerator.generateMachineRomSetXml(zipView);
                break;
            }
            case "softwarelist-rom": {
                RomSetXmlGenerator.generateSoftwareListRomSetXml(zipView);
                break;
            }
            case "machine-chd": {
                RomSetXmlGenerator.generateMachineChdSetXml(zipView);
                break;
            }
            case "softwarelist-chd": {
                RomSetXmlGenerator.generateSoftwareListChdSetXml(zipView);
                break;
            }
            default: {
                System.err.println("ERROR: Unrecognized collection type argument");
            }
        }
    }

    public static void generateMachineRomSetXml(Document zipView) throws Exception {
        Element caption = zipView.select("caption").first();
        Pattern p = Pattern.compile("listing\\ of\\ (.+)\\.[ziptar]{3}");
        Matcher m = p.matcher(caption.text());
        if (!m.matches()) {
            throw new RuntimeException("Can't parse collection id from caption. Regex does not match");
        }
        String id = m.group(1);
        Elements trs = zipView.select("table[class=archext]").first().select("tr:has(td:has(a))");
        HashMap<String, MachineRomSetFile> files = new HashMap<String, MachineRomSetFile>();
        for (Element tr : trs) {
            String size;
            Element a = tr.child(0).child(0);
            String url = "http:" + a.attr("href").toString();
            p = Pattern.compile(".+/(.+)\\.zip");
            m = p.matcher(a.text());
            if (!m.matches()) {
                System.err.println("Skip non rom file: " + url);
                continue;
            }
            String machineName = m.group(1);
            if (tr.children().size() <= 3) {
                System.err.println("Warning, can't parse size: " + tr);
                size = "0";
            } else {
                size = tr.child(3).text();
            }
            MachineRomSetFile file = new MachineRomSetFile(id, machineName, new URL(url), Long.parseLong(size));
            files.put(machineName, file);
        }
        MameVersion version = new MameVersion("0.150");
        MachineRomSet.MachineRomSetFormat format = MachineRomSet.MachineRomSetFormat.MERGED;
        MachineRomSet romSet = new MachineRomSet(version, new HashSet<Collection>(), format, files);
        JAXB.marshal((Object)romSet, System.out);
    }

    public static void generateSoftwareListRomSetXml(Document zipView) throws Exception {
        Element caption = zipView.select("caption").first();
        Pattern p = Pattern.compile("listing\\ of\\ (.+)\\.zip");
        Matcher m = p.matcher(caption.text());
        if (!m.matches()) {
            throw new RuntimeException("Can't parse collection id from caption. Regex does not match");
        }
        String id = m.group(1);
        Elements trs = zipView.select("table[class=archext]").first().select("tr:has(td:has(a))");
        HashMap<String, Map<String, SoftwareListRomSetFile>> files = new HashMap<String, Map<String, SoftwareListRomSetFile>>();
        for (Element tr : trs) {
            String size;
            Element a = tr.child(0).child(0);
            String url = "http:" + a.attr("href").toString();
            p = Pattern.compile(".+/(.+)/(.+)\\.zip");
            m = p.matcher(a.text());
            if (!m.matches()) {
                System.err.println("youpi");
                System.err.println("Skip non rom file: " + url);
                continue;
            }
            String listName = m.group(1);
            String softwareName = m.group(2);
            if (tr.children().size() <= 3) {
                System.err.println("Warning, can't parse size: " + tr);
                size = "0";
            } else {
                size = tr.child(3).text();
            }
            SoftwareListRomSetFile file = new SoftwareListRomSetFile(id, listName, softwareName, new URL(url), Long.parseLong(size));
            if (!files.containsKey(listName)) {
                files.put(listName, new HashMap());
            }
            ((Map)files.get(listName)).put(softwareName, file);
        }
        MameVersion version = new MameVersion("0.150");
        SoftwareListRomSet romSet = new SoftwareListRomSet(version, new HashSet<Collection>(), files);
        JAXB.marshal((Object)romSet, System.out);
    }

    public static void generateMachineChdSetXml(Document zipView) throws Exception {
        Element caption = zipView.select("caption").first();
        Pattern p = Pattern.compile("listing\\ of\\ (.+)\\.[tarzip]{3}");
        Matcher m = p.matcher(caption.text());
        if (!m.matches()) {
            throw new RuntimeException("Can't parse collection id from caption. Regex does not match");
        }
        String id = m.group(1);
        Elements trs = zipView.select("table[class=archext]").first().select("tr:has(td:has(a))");
        HashMap<String, Map<String, MachineChdSetFile>> files = new HashMap<String, Map<String, MachineChdSetFile>>();
        for (Element tr : trs) {
            String size;
            Element a = tr.child(0).child(0);
            String url = "http:" + a.attr("href").toString();
            p = Pattern.compile(".+/(.+)/(.+\\.chd)");
            m = p.matcher(a.text());
            if (!m.matches()) {
                System.err.println("Skip non rom file: " + url);
                continue;
            }
            String machineName = m.group(1);
            String chd = m.group(2);
            if (tr.children().size() <= 3) {
                System.err.println("Warning, can't parse size: " + tr);
                size = "0";
            } else {
                size = tr.child(3).text();
            }
            MachineChdSetFile file = new MachineChdSetFile(id, machineName, chd, new URL(url), Long.parseLong(size));
            if (!files.containsKey(machineName)) {
                files.put(machineName, new HashMap());
            }
            ((Map)files.get(machineName)).put(chd, file);
        }
        MameVersion version = new MameVersion("0.150");
        MachineChdSet chdSet = new MachineChdSet(version, new HashSet<Collection>(), files);
        JAXB.marshal((Object)chdSet, System.out);
    }

    public static void generateSoftwareListChdSetXml(Document zipView) throws Exception {
        Element caption = zipView.select("caption").first();
        Pattern p = Pattern.compile("listing\\ of\\ (.+)\\.zip");
        Matcher m = p.matcher(caption.text());
        if (!m.matches()) {
            throw new RuntimeException("Can't parse collection id from caption. Regex does not match");
        }
        String id = m.group(1);
        Elements trs = zipView.select("table[class=archext]").first().select("tr:has(td:has(a))");
        HashMap<String, Map<String, Map<String, SoftwareListChdSetFile>>> files = new HashMap<String, Map<String, Map<String, SoftwareListChdSetFile>>>();
        for (Element tr : trs) {
            String size;
            Element a = tr.child(0).child(0);
            String url = "http:" + a.attr("href").toString();
            p = Pattern.compile(".+_(.+)/(.+)/(.+)\\.chd");
            m = p.matcher(a.text());
            if (!m.matches()) {
                System.err.println("Skip non rom file: " + url);
                continue;
            }
            String listName = m.group(1);
            String softwareName = m.group(2);
            String chdName = m.group(3);
            if (tr.children().size() <= 3) {
                System.err.println("Warning, can't parse size: " + tr);
                size = "0";
            } else {
                size = tr.child(3).text();
            }
            SoftwareListChdSetFile file = new SoftwareListChdSetFile(id, listName, softwareName, chdName, new URL(url), Long.parseLong(size));
            if (!files.containsKey(listName)) {
                files.put(listName, new HashMap());
            }
            if (!((Map)files.get(listName)).containsKey(softwareName)) {
                ((Map)files.get(listName)).put(softwareName, new HashMap());
            }
            ((Map)((Map)files.get(listName)).get(softwareName)).put(chdName, file);
        }
        MameVersion version = new MameVersion("0.150");
        SoftwareListChdSet chdSet = new SoftwareListChdSet(version, new HashSet<Collection>(), files);
        JAXB.marshal((Object)chdSet, System.out);
    }
}

