/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.internetarchive;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.tibennetwork.iarcade.IaRcade;
import org.tibennetwork.iarcade.internetarchive.Collection;
import org.tibennetwork.iarcade.internetarchive.RomSet;
import org.tibennetwork.iarcade.internetarchive.SoftwareListChdSetFile;
import org.tibennetwork.iarcade.internetarchive.SoftwareListChdSetFileXmlAdapter;
import org.tibennetwork.iarcade.mame.MameVersion;

public class SoftwareListChdSet
extends RomSet {
    public static TreeSet<MameVersion> versions = new TreeSet();
    @XmlJavaTypeAdapter(value=SoftwareListChdSetFileXmlAdapter.class)
    private final Map<String, Map<String, Map<String, SoftwareListChdSetFile>>> files;

    public static SoftwareListChdSet findBest(MameVersion version) {
        MameVersion bestVersion;
        if (versions.contains(version)) {
            bestVersion = version;
        } else {
            bestVersion = versions.floor(version);
            IaRcade.warn("No archive.org softlist CHD set matches your Mame version");
            IaRcade.warn("Some files might not be available.");
        }
        StringBuilder builder = new StringBuilder("softwarelist-chd-set/");
        builder.append(bestVersion);
        builder.append(".xml");
        InputStream stream = SoftwareListChdSet.class.getClassLoader().getResourceAsStream(builder.toString());
        SoftwareListChdSet chdSet = JAXB.unmarshal(stream, SoftwareListChdSet.class);
        return chdSet;
    }

    public SoftwareListChdSet(MameVersion version, Set<Collection> collections, Map<String, Map<String, Map<String, SoftwareListChdSetFile>>> files) {
        super(version, collections);
        this.files = files;
    }

    public boolean contains(String softwareList, String software, String chd) {
        if (this.files.containsKey(softwareList)) {
            if (this.files.get(softwareList).containsKey(software)) {
                return this.files.get(softwareList).get(software).containsKey(chd);
            }
            return false;
        }
        return false;
    }

    public void download(File writableRomPath, String softwareList, String software, String chdName) {
        SoftwareListChdSetFile chd = this.files.get(softwareList).get(software).get(chdName);
        Collection col = this.getCollection(chd.getCollectionId());
        StringBuilder builder = new StringBuilder("Found ");
        builder.append(chd.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("Collection: ");
        builder.append(col.getName());
        IaRcade.info(builder.toString());
        builder = new StringBuilder("URL: ");
        builder.append(col.getUrl());
        IaRcade.info(builder.toString());
        builder = new StringBuilder(writableRomPath.getAbsolutePath());
        builder.append(File.separator);
        builder.append(chd.getName());
        String destPath = builder.toString();
        this.downloadFile(chd.getUrl(), destPath, chd.getSize());
    }

    public SoftwareListChdSet() {
        super(null, null);
        this.files = null;
    }

    static {
        versions.add(new MameVersion("0.149"));
    }
}

