/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.mame;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MachineDoesntExistException;
import org.tibennetwork.iarcade.mame.MameExecutionException;
import org.tibennetwork.iarcade.mame.MameRuntime;

public class MachineRepository {
    private MameRuntime mame;

    public MachineRepository(MameRuntime mame) {
        this.mame = mame;
    }

    public Machine findByName(String machineName) throws IOException, InterruptedException, MachineDoesntExistException {
        String[] mameCommandLine = new String[]{"-listxml", machineName};
        MameXmlContainer ms = null;
        try {
            InputStream is = this.mame.executeAndReturnStdoutAsInputStream(mameCommandLine);
            ms = JAXB.unmarshal(is, MameXmlContainer.class);
        }
        catch (DataBindingException | MameExecutionException e) {
            throw (MachineDoesntExistException)new MachineDoesntExistException(String.format("The machine '%s' doesn't exist or is not supported by the provided Mame version", machineName)).initCause(e);
        }
        Machine machine = null;
        HashSet<Machine> subMachines = new HashSet<Machine>();
        for (Machine m : ms.getMachines()) {
            if (m.getName().equals(machineName.toLowerCase())) {
                String romof;
                machine = m;
                String cloneof = m.getCloneof();
                if (cloneof != null) {
                    m.setClonedMachine(this.findByName(cloneof));
                }
                if ((romof = m.getRomof()) == null) continue;
                m.setRomOfMachine(this.findByName(romof));
                continue;
            }
            subMachines.add(m);
        }
        if (machine == null) {
            throw new RuntimeException(String.format("Unhandled case: Mame returned no errors while searching for machine %s but the machine has not been found on the XML content", machineName));
        }
        machine.setSubMachines(subMachines);
        return machine;
    }

    @XmlRootElement(name="mame")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MameXmlContainer {
        @XmlElements(value={@XmlElement(name="game"), @XmlElement(name="machine")})
        private List<Machine> machines = new ArrayList<Machine>();

        public List<Machine> getMachines() {
            return this.machines;
        }

        public void setMachines(List<Machine> machines) {
            this.machines = machines;
        }
    }
}

