/*
 * Decompiled with CFR 0.152.
 */
package org.tibennetwork.iarcade.mame;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.tibennetwork.iarcade.mame.Machine;
import org.tibennetwork.iarcade.mame.MediaDevice;
import org.tibennetwork.iarcade.mame.SoftwareChdFile;
import org.tibennetwork.iarcade.mame.SoftwareList;
import org.tibennetwork.iarcade.mame.SoftwareRomFile;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Software {
    @XmlAttribute(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="year")
    private String year;
    @XmlElement(name="publisher")
    private String publisher;
    @XmlElement(name="part")
    private List<Part> parts = new ArrayList<Part>();
    @XmlAttribute(name="cloneof")
    private String cloneof;
    private Machine machine;
    private MediaDevice mediaDevice;
    private SoftwareList softwareList;
    private String regularFileName;
    private Software original;

    public Software() {
    }

    public Software(Machine m, MediaDevice md, String name) {
        this.machine = m;
        this.mediaDevice = md;
        this.regularFileName = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getYear() {
        return this.year;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public String getCloneof() {
        return this.cloneof;
    }

    public void setCloneof(String cloneof) {
        this.cloneof = cloneof;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public MediaDevice getMediaDevice() {
        return this.mediaDevice;
    }

    public SoftwareList getSoftwareList() {
        return this.softwareList;
    }

    public void setSoftwareList(SoftwareList softwareList) {
        this.softwareList = softwareList;
    }

    public Software getOriginal() {
        return this.original;
    }

    public void setOriginal(Software original) {
        this.original = original;
    }

    public boolean isRegularFile() {
        return this.regularFileName != null;
    }

    public String getMediaInterface() {
        if (this.isRegularFile()) {
            return this.mediaDevice.getMediaInterface();
        }
        Iterator<Part> iterator = this.parts.iterator();
        if (iterator.hasNext()) {
            Part p = iterator.next();
            return p.getDeviceInterface();
        }
        return null;
    }

    public boolean isAClone() {
        return this.cloneof != null;
    }

    public String toString() {
        return this.isRegularFile() ? String.format("Software [device: %s, file: %s]", this.getMediaInterface(), this.regularFileName) : String.format("Software: [device: %s, name: %s (%s), publisher: %s, machine: %s]", this.getMediaInterface(), this.description, this.name, this.publisher, this.machine.getDescription());
    }

    private Set<SoftwareChdFile> getNeededChdFiles() {
        HashSet<SoftwareChdFile> neededFiles = new HashSet<SoftwareChdFile>();
        for (Part p : this.parts) {
            if (!(p.getName().matches("^cdrom[0-9]*$") | p.getName().matches("^hdd[0-9]*$"))) continue;
            neededFiles.add(new SoftwareChdFile(this.softwareList.getName(), this.name, p.getDiskarea().getDisk().getName()));
        }
        return neededFiles;
    }

    public Set<SoftwareChdFile> getMissingChdFiles(Set<File> romPaths) {
        HashSet<SoftwareChdFile> missingFiles = new HashSet<SoftwareChdFile>();
        block0: for (SoftwareChdFile chd : this.getNeededChdFiles()) {
            for (File romPath : romPaths) {
                File chdFileInRomPath = new File(romPath.getAbsolutePath() + File.separator + chd.getRelativePath());
                if (!chdFileInRomPath.exists()) continue;
                continue block0;
            }
            missingFiles.add(chd);
        }
        return missingFiles;
    }

    public Set<SoftwareRomFile> getNeededRomFiles() {
        for (Part p : this.parts) {
            if (!p.getName().matches("^cdrom[0-9]*$")) continue;
            return new HashSet<SoftwareRomFile>();
        }
        HashSet<SoftwareRomFile> neededRomFiles = new HashSet<SoftwareRomFile>();
        neededRomFiles.add(new SoftwareRomFile(this.softwareList.getName(), this.name));
        if (this.isAClone()) {
            neededRomFiles.addAll(this.original.getNeededRomFiles());
        }
        return neededRomFiles;
    }

    public Set<SoftwareRomFile> getMissingRomFiles(Set<File> romPaths) {
        HashSet<SoftwareRomFile> missingRomFiles = new HashSet<SoftwareRomFile>();
        block0: for (SoftwareRomFile file : this.getNeededRomFiles()) {
            for (File romPath : romPaths) {
                File zippedFileInRomPath = new File(romPath.getAbsolutePath() + File.separator + file.getZipRelativePath());
                File sevenZippedFileInRomPath = new File(romPath.getAbsolutePath() + File.separator + file.getSevenZipRelativePath());
                if (!zippedFileInRomPath.exists() && !sevenZippedFileInRomPath.exists()) continue;
                continue block0;
            }
            missingRomFiles.add(file);
        }
        return missingRomFiles;
    }

    public boolean areFilesAvailable(Set<File> romPaths) {
        return this.getMissingRomFiles(romPaths) == null && this.getMissingChdFiles(romPaths) == null;
    }

    @XmlRootElement
    static class Part {
        @XmlAttribute(name="name")
        private String name;
        @XmlAttribute(name="interface")
        private String deviceInterface;
        @XmlElement
        private DiskArea diskarea;

        Part() {
        }

        public String getName() {
            return this.name;
        }

        public String getDeviceInterface() {
            return this.deviceInterface;
        }

        public DiskArea getDiskarea() {
            return this.diskarea;
        }

        static class DiskArea {
            @XmlElement(name="disk")
            private Disk disk;

            DiskArea() {
            }

            public Disk getDisk() {
                return this.disk;
            }

            static class Disk {
                @XmlAttribute(name="name")
                private String name;

                Disk() {
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }
}

